<?php

namespace App\Http\Controllers;

use App\BudgetPostCost;
use App\Exports\BudgetPostExport;
use App\Order;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

class BudgetPostCostController extends Controller
{
    public $pageData = [];
    public $pageName;
    public $viewFolder = 'budgetPostCost';

    public function __construct()
    {
        $this->pageName = $this->viewFolder;
        $this->pageData = [
            'no' => 0,
            'pageName' => Str::studly($this->pageName),
            'routeFirstName' => 'budget-post-cost',
            'ignoreColsInExport' => '[0]',
        ];

        view()->share('pageData', $this->pageData);

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //dd($request->all());
        $query = Order::query()->where('history_type', 'Running');
        $query = $query->with(['budget', 'buyer', 'status', 'shipment']);
        $id = $request->get('id') ?? null;
        $buyer_id = $request->get('buyer_id') ?? null;
        $name = $request->get('name') ?? null;
        $style = $request->get('style') ?? null;
        $style_desc = $request->get('style_desc') ?? null;
        $statuses = $request->get('statuses') ?? null;
        $category_id = $request->get('category_id') ?? null;
        $sub_category_id = $request->get('sub_category_id') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('name')) {
            $query = $query->where('name', $request->get('name') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style')) {
            $query = $query->where('style', $request->get('style') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style_desc')) {
            $query = $query->where('style_desc', $request->get('style_desc') );
            //$phone = $request->get('phone');
        }
        if($request->filled('statuses')) {
            $query = $query->where('statuses', $request->get('statuses') );
            //$phone = $request->get('phone');
        }
        if($request->filled('sub_category_id')) {
            $query = $query->where('sub_category_id', $request->get('sub_category_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('from') && $request->filled('to')) {
            $query = $query->whereBetween('date_of_ship', [$request->get('from'), $request->get('to')] );
            //$phone = $request->get('phone');
        }

        /*last 10 days*/
        if(!$request->has('data_filtering')) {
            $today = date('Y-m-d');
            $hasDays = date('Y-m-d', strtotime('10 days', strtotime($today)));

            $query = $query->whereBetween('date_of_ship', [$today, $hasDays]);
        }
        /*end last 10 days*/

        $orders = $query->orderBy('date_of_ship')->get();

        $compact = compact(
            'id',
            'buyer_id',
            'name',
            'style',
            'style_desc',
            'statuses',
            'category_id',
            'sub_category_id',
            'from',
            'to',
            'per_page',
            'orders'
        );

        return view($this->pageName.'.index', $compact)
            ->withCount($query->get()->count())
            ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $filterOrder = (new UtilityController)->filterOrder($request);

        $id = $request->get('id') ?? null;

        $compact = compact(
            'id'
        );

        $compact += $filterOrder;

        $order = Order::find($id);


        /*$orderSizeAndColorArr = [];
        if ($order) {
            foreach($order->quantity as $sNcWiseQty){
                $orderSizeAndColorArr[$sNcWiseQty->color->name]['color_id'] = $sNcWiseQty->color_id;
                $orderSizeAndColorArr[$sNcWiseQty->color->name]['sz'][] = $sNcWiseQty->size->name;
                $orderSizeAndColorArr[$sNcWiseQty->color->name]['qty'][] = $sNcWiseQty->quantity;
            }
        }*/


        return view($this->viewFolder.'.create', $compact)
            ->withOrder($order)
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all(), date('Y-m-d'), $this->pageData['routeFirstName'].'-create');
        $request->validate([
            'chalan_no' => 'required|max:255',
            'supplier_id' => 'required|max:255',
            'cost' => 'required|max:255',
            'budget_cost_type' => 'required|max:255',
        ]);

        $mainData = new BudgetPostCost();
        $mainData->chalan_no = $request['chalan_no'];
        $mainData->order_id = $request['order_id'];
        $mainData->budget_id = $request['budget_id'];
        $mainData->supplier_id = $request['supplier_id'];
        $mainData->cost = $request['cost'];
        $mainData->post_cost_type = $request['budget_cost_type'];

        $mainData->date = date('Y-m-d');

        if ($request->filled('date')) {
            $mainData->date = $request['date'];
        }

        $mainData->save();
        return redirect()->route($this->pageData['routeFirstName'].'-create', ['id'=>$request['order_id']])->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\BudgetPostCost  $budgetPostCost
     * @return \Illuminate\Http\Response
     */
    public function show(Order $order)
    {
        return view('layouts.orderDetails.show')
            ->withOrder($order)
            ;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\BudgetPostCost  $budgetPostCost
     * @return \Illuminate\Http\Response
     */
    public function edit(BudgetPostCost $budgetPostCost)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\BudgetPostCost  $budgetPostCost
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, BudgetPostCost $budgetPostCost)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\BudgetPostCost  $budgetPostCost
     * @return \Illuminate\Http\Response
     */
    public function destroy(BudgetPostCost $budgetPostCost)
    {
        //
    }

    public function export()
    {
        return Excel::download(new BudgetPostExport(), 'myFile.xlsx');
    }

    public function budgetPostCostFetchModalData(Order $order, $type)
    {
        return $order->budgetPostCost->where('post_cost_type', $type)->map(function ($postCost){
            $postCost->supplier; // get supplier in this array
            return $postCost;
        });
    }

    public function budgetPostCostEditModalData(BudgetPostCost $budgetPostCost, Request $request)
    {

        if ($request->filled('chalan_no')) {
            $budgetPostCost->chalan_no = $request['chalan_no'];
        }

        if ($request->filled('date')) {
            $budgetPostCost->date = $request['date'];
        }

        if ($request->filled('cost')) {
            $budgetPostCost->cost = $request['cost'];
        }

        $budgetPostCost->save();

        return ($budgetPostCost);
    }
}
