<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBusinessGapsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_gaps', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable()->unsigned();
            $table->integer('update_user_id')->nullable()->unsigned();
            $table->integer('reporting_to_user_id')->nullable()->unsigned();
            $table->integer('prev_status_id')->nullable()->unsigned();
            $table->enum('data_status', ['running', 'edit', 'done', 'delete'])->default('running');
            $table->enum('approve_status', ['Pending', 'Approve', 'NotApprove'])->default('Approve');
            $table->text('description')->nullable();

            $table->double('receivable_from_cash_lc')->nullable();
            $table->double('usd_ac_balance')->nullable();
            $table->double('cash_incentive')->nullable();
            $table->double('fdr')->nullable();
            $table->double('usd_ac')->nullable();
            $table->double('ac_receivable')->nullable();
            $table->double('stock_or_inventory')->nullable();
            $table->double('yarn_block_lc')->nullable();
            $table->double('others')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_gaps');
    }
}
