window.onpopstate = function(e){
    if(e.state){
        let url = window.location.toString();
        let queryString = url.split("?")[1];
        ajaxRequest(queryString);
    }
};


/*if (window.history.replaceState) {
    //prevents browser from storing history with each change:
    //window.history.replaceState(statedata, title, url);
}*/

function ajaxFilter(e) {

    e.preventDefault();

    let myForm = document.querySelector('[action="#search-area"]');
    const queryString = new URLSearchParams(new FormData(myForm)).toString()

    window.history.pushState({}, null, orderListRoute + '?' + queryString); // make url

    ajaxRequest(queryString);
}

function ajaxRequest(queryString) {
    $.ajax({
        url: orderTableRoute + '?' + queryString, // from header file
        success(data){
            oTable.clear().draw();

            let tr = $($.parseHTML(data)).find('tbody tr');

            tr.each(function (index, tr) {
                let allTd = [...tr.querySelectorAll('td')].map(function (td, tdIndex) {
                    return(td.innerHTML);
                });

                oTable.row.add(allTd).draw(false);
            });

            pieChartStateChange(function (data) {

                let piObj = {
                    elm: 'container',
                    seriesName: 'Quantity',
                    heading: 'Buyer Wise Order Quantity',
                };
                let piObj2 = {
                    elm: 'container2',
                    seriesName: 'Value',
                    heading: 'Buyer Wise Order Value',
                };

                chartNSummery(piObj, piData('quantity', data));
                chartNSummery(piObj2, piData('value', data));

                vm.buyerWiseSummaries = data;
            });

            if (typeof dataTableFooterSum === "function") {
                dataTableFooterSum({
                    table: oTable
                });
            }

        }
    });
}
