@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"> {{ isset($isSetModel)? 'Edit':'Place' }} {{ $pageData['pageName'] }}</h3>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Default Light Table -->

        <form action="{{ route($pageData['routeFirstName'].'-store') }}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-lg-8">


                        <div class="card card-small mb-4">
                                    <div class="card-header border-bottom">
                                        <h6 class="m-0">{{ $pageData['pageName'] }} Details</h6>
                                    </div>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item p-3">
                                            <div class="row">
                                                <div class="col">



                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>Receivable from cash LC</label>
                                                            <input name="receivable_from_cash_lc" type="number" step="any"
                                                                   class="form-control"
                                                                   placeholder="Receivable from cash LC"
                                                                   value="{{ $isSetModel->receivable_from_cash_lc ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>USD Ac Balance</label>
                                                            <input value="{{ $isSetModel->usd_ac_balance ?? null }}"
                                                                   name="usd_ac_balance" type="number" step="any" class="form-control"
                                                                   placeholder="USD Ac Balance">
                                                        </div>
                                                    </div>

                                                    <div class="form-row">

                                                        <div class="form-group col-md-4">
                                                            <label>Cash incentive</label>
                                                            <input name="cash_incentive" type="number" step="any"
                                                                   class="form-control"
                                                                   placeholder="Cash incentive"
                                                                   value="{{ $isSetModel->cash_incentive ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>FDR</label>
                                                            <input name="fdr" type="number" step="any"
                                                                   class="form-control"
                                                                   placeholder="FDR"
                                                                   value="{{ $isSetModel->fdr ?? null }}">
                                                        </div>

                                                    </div>





                                                    <div class="form-row">


                                                        <div class="form-group col-md-4">
                                                            <label>USD Ac</label>
                                                            <input name="usd_ac" type="number" step="any" class="form-control"
                                                                   placeholder="USD Ac"
                                                                   value="{{ $isSetModel->usd_ac ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>AC receivable</label>
                                                            <input name="ac_receivable" type="number" step="any" class="form-control"
                                                                   placeholder="AC receivable"
                                                                   value="{{ $isSetModel->ac_receivable ?? null }}">
                                                        </div>

                                                    </div>

                                                    <div class="form-row">


                                                        <div class="form-group col-md-4">
                                                            <label>Yarn Block lC</label>
                                                            <input name="yarn_block_lc" type="number" step="any" class="form-control"
                                                                   placeholder="Yarn Block lC"
                                                                   value="{{ $isSetModel->yarn_block_lc ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>Others</label>
                                                            <input name="others" type="number" step="any" class="form-control"
                                                                   placeholder="Others"
                                                                   value="{{ $isSetModel->others ?? null }}">
                                                        </div>

                                                    </div>

                                                    <div class="form-row">

                                                        <div class="form-group col-md-8">
                                                            <label>Stock/inventory</label>
                                                            <input value="{{ $isSetModel->stock_or_inventory ?? null }}"
                                                                   name="stock_or_inventory" type="number" step="any" class="form-control"
                                                                   placeholder="Document Purchase Amount">
                                                        </div>
                                                    </div>



                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label>About {{ $pageData['pageName'] }}</label>
                                                            <textarea v-model="aboutUser" name="description" class="form-control" rows="5">{{$isSetModel->description ?? null}}</textarea>
                                                        </div>
                                                    </div>
                                                    <button type="submit" class="btn btn-accent">Save</button>

                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                </div>

                            {{--Budget--}}

            </div>

        </form>
                    <!-- End Default Light Table -->
    </div>
@endsection

@section('vue-script')

@endsection

