@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"> {{ isset($isSetModel)? 'Edit':'Place' }} {{ $pageData['pageName'] }}</h3>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Default Light Table -->

        @if(isset($isSetModel))
            <form action="{{ route($pageData['routeFirstName'].'-update', $isSetModel->id) }}" method="post" enctype="multipart/form-data">
            @method('PATCH')

                @if(false)
                    {{--For IDE--}} </form> {{--For IDE--}}
                @endif

        @else
            <form action="{{ route($pageData['routeFirstName'].'-store') }}" method="post" enctype="multipart/form-data">
        @endif
            @csrf
            <div class="row">
                <div class="col-lg-8">

                    <div style="display: flex; justify-content: space-between; width: 100%;">

                        @if(isset($isSetModel) && $isSetModel->history_type == 'notApprove')
                            <a href="{{ route($pageData['routeFirstName'].'-approve-order', $isSetModel->id) }}" class="btn btn-lg btn-java">Approve this Order</a>
                        @endif

                    </div>

                    <hr>


                        <div class="card card-small mb-4">
                                    <div class="card-header border-bottom">
                                        <h6 class="m-0">{{ $pageData['pageName'] }} Details</h6>
                                    </div>
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item p-3">
                                            <div class="row">
                                                <div class="col">

                                                    <div class="form-row">
{{--                                                        <div class="form-group col-md-6">--}}
{{--                                                            <label>Item--}}
{{--                                                                Name</label>--}}
{{--                                                            <input v-model="fullName" name="item_name" type="text"--}}
{{--                                                                   autocomplete="off"--}}
{{--                                                                   class="form-control"--}}
{{--                                                                   placeholder="{{ $pageData['pageName'] }} Name"--}}
{{--                                                                   value="{{ $isSetModel->item_name ?? null }}">--}}
{{--                                                        </div>--}}


                                                       <div class="form-group col-md-6">
                                                            <label>Buyer Name
                                                                <a target="_blank" href="{{ route('party-create') }}">
                                                                    <i class="material-icons">control_point</i>
                                                                </a>
                                                            </label>
                                                            <select class="select2-box form-control" name="buyer_id" laravel-model="Buyer" laravel-get-from="name">
                                                                <option value="{{ $isSetModel->buyer_id ?? null }}">{{ $isSetModel->buyer->name ?? null }}</option>
                                                            </select>
                                                        </div>

                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>Invoice Number</label>
                                                            <input name="invoice_number" type="text"
                                                                   class="form-control"
                                                                   placeholder="Invoice Number"
                                                                   value="{{ $isSetModel->invoice_number ?? null }}">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label>Invoice Date</label>
                                                            <input name="invoice_date" type="date"
                                                                   class="form-control"
                                                                   placeholder="Invoice Date"
                                                                   value="{{ $isSetModel->invoice_date ?? null }}">
                                                        </div>
                                                        <div class="form-group col-md-4">
                                                            <label>Invoice Value</label>
                                                            <input value="{{ $isSetModel->invoice_value ?? null }}"
                                                                   name="invoice_value" type="number" step="any" class="form-control"
                                                                   placeholder="Invoice Value">
                                                        </div>
                                                    </div>

                                                    <div class="form-row">

                                                        <div class="form-group col-md-4">
                                                            <label>Payment Mode</label>
                                                            <input name="payment_mode" type="number" step="1" min="1" max="150" class="form-control"
                                                                   placeholder="Days"
                                                                   value="{{ $isSetModel->payment_mode ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>Master L/C No or S/C No</label>
                                                            <input name="master_lc_no_OR_sc_no" type="text"
                                                                   class="form-control"
                                                                   placeholder="Master L/C No or S/C No"
                                                                   value="{{ $isSetModel->master_lc_no_OR_sc_no ?? null }}">
                                                        </div>

                                                    </div>



                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>Ex. Factory Date</label>
                                                            <input name="ex_factory_date" type="date" class="form-control"
                                                                   value="{{ $isSetModel->ex_factory_date ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>B/L Date</label>
                                                            <input name="bl_date" type="date" class="form-control"
                                                                   placeholder="B/L Date"
                                                                   value="{{ $isSetModel->bl_date ?? null }}">
                                                        </div>

                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>Payment Receive Date</label>
                                                            <input name="payment_receive_date" type="date" class="form-control"
                                                                   placeholder="Payment Receive Date"
                                                                   value="{{ $isSetModel->payment_receive_date ?? null }}">
                                                        </div>


                                                        <div class="form-group col-md-4">
                                                            <label>Payment Receive Amount</label>
                                                            <input name="payment_receive_amount" type="number" step="any" class="form-control"
                                                                   placeholder="Payment Receive Amount"
                                                                   value="{{ $isSetModel->payment_receive_amount ?? null }}">
                                                        </div>

                                                        <div class="form-group col-md-4">
                                                            <label>Payment Receive Status</label>
                                                            <select class="select2-box-manual form-control" name="payment_receive_status">
                                                                <option value="{{ $isSetModel->payment_receive_status ?? 'ReceiveDue' }}">{{ $isSetModel->payment_receive_status ?? 'Receive Due' }}</option>
                                                                <option value="ReceiveDue">ReceiveDue</option>
                                                                <option value="FullyReceive">FullyReceive</option>
                                                                <option value="PartialReceive">PartialReceive</option>
                                                            </select>
                                                        </div>

                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-4">
                                                            <label>Document Purchase Date</label>
                                                            <input name="document_purchase_date" type="date"
                                                                   class="form-control"
                                                                   placeholder="Document Purchase Date"
                                                                   value="{{ $isSetModel->document_purchase_date ?? null }}">
                                                        </div>
                                                        <div class="form-group col-md-8">
                                                            <label>Document Purchase Amount</label>
                                                            <input value="{{ $isSetModel->document_purchase_amount ?? null }}"
                                                                   name="document_purchase_amount" type="number" step="any" class="form-control"
                                                                   placeholder="Document Purchase Amount">
                                                        </div>
                                                    </div>

                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label>About {{ $pageData['pageName'] }}</label>
                                                            <textarea v-model="aboutUser" name="description" class="form-control" rows="5">{{$isSetModel->description ?? null}}</textarea>
                                                        </div>
                                                    </div>
                                                    <button type="submit" class="btn btn-accent">Save</button>

                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                </div>

                            {{--Budget--}}

            </div>

        </form>
                    <!-- End Default Light Table -->
    </div>
@endsection

@section('vue-script')

@endsection

