@php
$pieChartMaterials = [];
@endphp

@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title">{{ $pageData['pageName'] }} List</h3>
            </div>
            <div class="float-right col-12 col-sm-8 text-center text-sm-right">
                <span class="text-uppercase page-subtitle">Action</span>
                <h3 class="page-title">
                    <a href="{{ route($pageData['routeFirstName'].'-create') }}" class="btn btn-md btn-white">
                        <i class="material-icons">control_point</i> Add {{ $pageData['pageName'] }}
                    </a>
                </h3>
            </div>
        </div>





        {{--Star filter form--}}
        @include('layouts.tools.filterFormForCommercial_invoiceReport')
        {{--End filter form--}}




        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span>{{ $count }} {{ ($count>1)?Str::plural($pageData['pageName']):$pageData['pageName'] }} Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        {{--From Controller--}}
                        <h6 class="m-0">Active {{ Str::plural($pageData['pageName']) }}</h6>
                    </div>
                    <div class="card-body p-0 text-center pre-x-scrollable" id="order-table">



                        <!-- Transaction History Table -->
                        @include('commercial_Invoice.table')
                        <!-- End Transaction History Table -->



                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="promo-popup animated bounceIn" style="padding: 10px; border: 2px solid #898989; background: rgba(255,255,255,0.82); right: 10px;">

        <div>
            <a href="#accordion">
            <span class="close">
                <i class="material-icons">pie_chart</i>
            </span>
            </a>
        </div>


        <div>
            <a href="#search-area">
            <span class="close">
                <i class="material-icons">format_align_left</i>
            </span>
            </a>
        </div>

    </div>
@endsection

@section('vue-script')

{{--start php code--}}

{{--end php code--}}


    @include('js/script')
    <script>

        $('[name="filterYearChart"]').change(function () {
            //alert($(this).val())
            window.location = '?direct=true&filterYearChart='+$(this).val();
        });





        function dataTableFooterSum(obj) {
            let tbl = obj.table;
            [4, 11, 14, 15].forEach(function (col) { //10.OrderQty, 12.TotValue, 13.ShipQty, 15.ShipValue, 16.ShortShipVal
                //console.log(tbl.column(col).footer());
                $(tbl.column(col).footer()).html(
                    roundWithFrac(tbl.column(col).data().sum())
                );
            });

            /*custom sum footer*/
            /*let totVal = $(tbl.column(12).footer()).text();
            let totOrdQty = $(tbl.column(10).footer()).text();
            let totCm = $(tbl.column(19).footer()).text();
            let totYrn = $(tbl.column(21).footer()).text();*/

            //console.log(totYrn);
            //console.log(tbl.column(10).footer());

            /*$(tbl.column(11).footer()).html(
                roundWithFrac(totVal/totOrdQty) /!*unit price avr*!/
            );
            $(tbl.column(18).footer()).html(
                roundWithFrac(totCm/totOrdQty * 12)
            );
            $(tbl.column(20).footer()).html(
                roundWithFrac((totYrn * 12) / totOrdQty)
            );*/
            /*custom sum footer*/
        }




    </script>
@endsection
