@php
$pieChartMaterials = [];
@endphp

@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title">{{ $pageData['pageName'] }} List</h3>
            </div>
            <div class="float-right col-12 col-sm-8 text-center text-sm-right">
                <span class="text-uppercase page-subtitle">Action</span>
                <h3 class="page-title">
                    <a href="{{ route($pageData['routeFirstName'].'-create') }}" class="btn btn-md btn-white">
                        <i class="material-icons">control_point</i> Add {{ $pageData['pageName'] }}
                    </a>
                </h3>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 mb-3">
                <div id="accordion" style="cursor: pointer">
                    <div class="card card-small mb-1 rounded">
                        <select class="select2-box-manual form-control yr-select" name="filterYearChart">
                            <option value="2015">2015</option>
                            <option value="2016">2016</option>
                            <option value="2017">2017</option>
                            <option value="2018">2018</option>
                            <option value="2019">2019</option>
                            <option value="2020">2020</option>
                            <option value="2021">2021</option>
                            <option value="2022">2022</option>
                            <option value="2023">2023</option>
                            <option value="2024">2024</option>
                        </select>
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 card-link" data-toggle="collapse" href="#collapseThree">

                                {{--start php code--}}
                                <?php

                                $startMonth = (App\Setting::where('name', 'shipmentScheduleChartStartMonth')->first()->value) ?? "Jan";
                                $selectedYear = (App\Setting::where('name', 'shipmentScheduleChartStartYear')->first()->value) ?? '0';


                                ?>
                                {{--end php code--}}

                                Yearly Chart (<b class="text-primary">Default Chart Starting Time</b> - <b class="text-danger">{{ $startMonth == "Jan" ? "January" : "July" }} {{(date('Y') + $selectedYear)}}</b>)
                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseThree" class="collapse show" data-parent="#accordion">
                            <div class="card-body pt-0">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item p-2">
                                        <div class="row" style="height: 400px;">
                                            <div class="col-md-12">
                                                <div id="columnChart"></div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card card-small mb-1 rounded">
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 card-link" data-toggle="collapse" href="#collapseOne">
                                Chart
                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseOne" class="collapse" data-parent="#accordion">
                            <div class="card-body pt-0">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item p-2">
                                        <div class="row" style="height: 400px;">
                                            <div class="col-md-6">
                                                <div id="container"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <div id="container2"></div>
                                            </div>

                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card card-small mb-1">
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 collapsed card-link w-100" data-toggle="collapse" href="#collapseTwo">
                                Summery
                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseTwo" class="collapse" data-parent="#accordion">
                            <table class="summary-table text-capitalize">
                                <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Buyer</th>
                                    <th>Qty</th>
                                    <th>%</th>
                                    <th>Value</th>
                                    <th>%</th>
                                    <th>ShipQty</th>
                                    <th>%</th>
                                    <th>ShipValue</th>
                                    <th>%</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(list, key, i) in buyerWiseSummaries">
                                    <td>@{{ ++i }}</td>
                                    <td>@{{ key }}</td>
                                    <td>@{{ list.quantity.reduce(getSum,0) }}</td>
                                    <td>@{{ roundWithFrac((list.quantity.reduce(getSum,0)/orderSummerySum('quantity'))*100) }}</td>
                                    <td>@{{ roundWithFrac(list.value.reduce(getSum,0)) }}</td>
                                    <td>@{{ roundWithFrac((list.value.reduce(getSum,0)/orderSummerySum('value'))*100) }}</td>
                                    <td>@{{ list.shipQty.reduce(getSum,0) }}</td>
                                    <td>@{{ roundWithFrac((list.shipQty.reduce(getSum,0)/orderSummerySum('quantity'))*100) }}</td>
                                    <td>@{{ roundWithFrac(list.shipValue.reduce(getSum,0)) }}</td>
                                    <td>@{{ roundWithFrac((list.shipValue.reduce(getSum,0)/orderSummerySum('quantity'))*100) }}</td>
                                </tr>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th>Qty</th>
                                        <th></th>
                                        <th>Value</th>
                                        <th></th>
                                        <th>ShipQty</th>
                                        <th></th>
                                        <th>ShipValue</th>
                                        <th></th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td>@{{ orderSummerySum('quantity') }}</td>
                                        <td></td>
                                        <td>@{{ roundWithFrac(orderSummerySum('value')) }}</td>
                                        <td></td>
                                        <td>@{{ orderSummerySum('shipQty') }}</td>
                                        <td></td>
                                        <td>@{{ orderSummerySum('shipValue') }}</td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>




        {{--Star filter form--}}
        @include('layouts.tools.filterFormForReport')
        {{--End filter form--}}




        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span>{{ $count }} {{ ($count>1)?Str::plural($pageData['pageName']):$pageData['pageName'] }} Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        {{--From Controller--}}
                        <h6 class="m-0">Active {{ Str::plural($pageData['pageName']) }}</h6>
                    </div>
                    <div class="card-body p-0 text-center pre-x-scrollable" id="order-table">



                        <!-- Transaction History Table -->
                        @include('orders.table')
                        <!-- End Transaction History Table -->



                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="promo-popup animated bounceIn" style="padding: 10px; border: 2px solid #898989; background: rgba(255,255,255,0.82); right: 10px;">

        <div>
            <a href="#accordion">
            <span class="close">
                <i class="material-icons">pie_chart</i>
            </span>
            </a>
        </div>


        <div>
            <a href="#search-area">
            <span class="close">
                <i class="material-icons">format_align_left</i>
            </span>
            </a>
        </div>

    </div>
@endsection

@section('vue-script')

{{--start php code--}}
    <?php

    $orderModel = new App\Order();

    if (request()->has('filterYearChart')) {
        $orderYearWiseMonth = $orderModel->orderYearWiseMonth(request()->get('filterYearChart'), $startMonth);
    } else {
        $orderYearWiseMonth = $orderModel->orderYearWiseMonth(date('Y') + $selectedYear, $startMonth);
    }

    //dd(request()->get('filterYearChart'));

    ?>
{{--end php code--}}


    @include('js/script')
    <script>

        $('[name="filterYearChart"]').change(function () {
            //alert($(this).val())
            window.location = '?direct=true&filterYearChart='+$(this).val();
        });

        function dataTableFooterSum(obj) {
            let tbl = obj.table;
            [10, 12, 13, 14, 15, 19, 21, 22, 23].forEach(function (col) { //10.OrderQty, 12.TotValue, 13.ShipQty, 15.ShipValue, 16.ShortShipVal
                //console.log(tbl.column(col).footer());
                $(tbl.column(col).footer()).html(
                    roundWithFrac(tbl.column(col).data().sum())
                );
            });

            /*custom sum footer*/
            let totVal = $(tbl.column(12).footer()).text();
            let totOrdQty = $(tbl.column(10).footer()).text();
            let totCm = $(tbl.column(19).footer()).text();
            let totYrn = $(tbl.column(21).footer()).text();

            //console.log(totYrn);
            //console.log(tbl.column(10).footer());

            $(tbl.column(11).footer()).html(
                roundWithFrac(totVal/totOrdQty) /*unit price avr*/
            );
            $(tbl.column(18).footer()).html(
                roundWithFrac(totCm/totOrdQty * 12)
            );
            $(tbl.column(20).footer()).html(
                roundWithFrac((totYrn * 12) / totOrdQty)
            );
            /*custom sum footer*/
        }

        function pieChartStateChange(callback) {
            let url = window.location.toString();
            let queryString = url.split("?")[1];

            $.ajax({
                url: orderPieChart + '?' + queryString,
                success(data) {
                    callback(data);
                    console.log(data);
                }
            });
        }

        pieChartStateChange(function (data) {

            let piObj = {
                elm: 'container',
                seriesName: 'Quantity',
                heading: 'Buyer Wise Order Quantity',
            };
            let piObj2 = {
                elm: 'container2',
                seriesName: 'Value',
                heading: 'Buyer Wise Order Value',
            };

            chartNSummery(piObj, piData('quantity', data));
            chartNSummery(piObj2, piData('value', data));

            //summary-table
            vm.buyerWiseSummaries = data;
            //vm.totalQtyInfo = data[1];
        });

        function piData(type, data) {
            let $pieChartMaterials = data;

            return Object.keys($pieChartMaterials).map(function (k) {
                let val = $pieChartMaterials[k][type].reduce(function (qty, pilot) {
                    return qty + pilot
                },0);
                return {name: k, y:val};
            });
        }

        let qtyAvg = [@foreach($orderYearWiseMonth[0] as $month => $monthlyOrder)
                        {{ array_sum($orderYearWiseMonth[1][$month] ?? []) }},
                    @endforeach].reduce((a, b) => a + b, 0) / 12;

        let valAvg = [@foreach($orderYearWiseMonth[0] as $month => $monthlyOrder)
            {{ array_sum($orderYearWiseMonth[2][$month] ?? []) }},
            @endforeach].reduce((a, b) => a + b, 0) / 12;

        Highcharts.chart('columnChart', {

            chart: {
                type: 'column'
            },

            title: {
                text: 'Monthly Order'
            },

            xAxis: {
                categories: [
                    @foreach($orderModel->orderYearWiseMonth( date('Y'), $startMonth )[0] as $month => $monthlyOrder)
                    '{{ $month }}',
                    @endforeach
                ],
            },

            yAxis: [{
                plotLines: [
                        {
                        color: 'skyblue', // qty
                        width: 2,
                        dashStyle: 'dash',
                        label: {
                            text: Math.round(qtyAvg),
                            y:12,
                            style: {
                                color: '#3f92f1',
                                fontWeight: 'bold',
                                textShadow: '-1px 0 #fff, 0 1px #fff, 1px 0 #fff, 0 -1px #fff' // next update
                            }
                        },
                        value: qtyAvg,
                        zIndex: 5
                    },{
                        color: 'black', // val
                        width: 2,
                        dashStyle: 'dash',
                        label: {
                            text: Math.round(valAvg),
                            style: {
                                fontWeight: 'bold',
                                textShadow: '-1px 0 #fff, 0 1px #fff, 1px 0 #fff, 0 -1px #fff' // next update
                            }
                        },
                        value: valAvg,
                        zIndex: 5
                    }
                ],

                title: {
                    text: ''
                },
                linkedTo: 1,
                opposite: true
            },
            {
                title: {
                    text: 'Value axis'
                }
            }],

            plotOptions: {
                series: {
                    borderWidth: 0,
                    /*dataLabels: {
                        enabled: true,
                        format: '{point.y:.f}'
                    }*/
                },
                column: {
                    pointPadding: 0.05,
                    borderRadius: 3
                }
            },

            series: [
                {
                    name: 'Quantity',
                    data: [
                        @foreach($orderYearWiseMonth[0] as $month => $monthlyOrder)
                        {{ array_sum($orderYearWiseMonth[1][$month] ?? []) }},
                        @endforeach
                    ]
                }, {
                    name: 'Value',
                    data: [
                        @foreach($orderYearWiseMonth[0] as $month => $monthlyOrder)
                        {{ array_sum($orderYearWiseMonth[2][$month] ?? []) }},
                        @endforeach
                    ],
                    yAxis: 1
                }
            ],
            credits: {
                enabled: false
            },

        });



        function chartNSummery($piObj, data) {
            // Build the chart
            Highcharts.chart($piObj.elm, {
                // Radialize the colors
                colors: Highcharts.map(Highcharts.getOptions().colors, function (color) {
                    return {
                        radialGradient: {
                            cx: 0.5,
                            cy: 0.3,
                            r: 0.7
                        },
                        stops: [
                            [0, color],
                            [1, Highcharts.Color(color).brighten(-0.3).get('rgb')] // darken
                        ]
                    };
                }),
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: $piObj.heading
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.y}</b>'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            format: '<b>{point.name}</b>: {point.percentage:.1f} %',
                            style: {
                                color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                            },
                            connectorColor: 'silver'
                        }
                    }
                },
                series: [{
                    name: $piObj.seriesName,
                    data
                }],
                credits: {
                    enabled: false
                },
            });
        }
    </script>
@endsection
