<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('layouts.partial.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"> <?php echo e(isset($isSetEmail)? 'Edit':''); ?> <?php echo e($pageData['pageName']); ?> Profile</h3>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Default Light Table -->
        <div class="row">

            <div class="col-lg-8">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        <h6 class="m-0"><?php echo e($pageData['pageName']); ?> Details</h6>
                    </div>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-3">
                            <div class="row">
                                <div class="col">

                                    <?php if(isset($isSetEmail)): ?>
                                        <form action="<?php echo e(route($pageData['routeFirstName'].'-update', $isSetEmail->id)); ?>" method="post" enctype="multipart/form-data">
                                        <?php echo method_field('PATCH'); ?>
                                    <?php else: ?>
                                        <form action="<?php echo e(route($pageData['routeFirstName'].'-store')); ?>" method="post" enctype="multipart/form-data">
                                    <?php endif; ?>

                                        <?php echo csrf_field(); ?>

                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="feFirstName"> Name</label>
                                                <input v-model="fullName" name="name" type="text" class="form-control" id="feFirstName"
                                                       placeholder="Name" value="" <?php if(isset($isSetEmail)): ?> readonly <?php endif; ?>>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="feLastName">Set Name</label>


                                                <?php if(isset($isSetEmail)): ?>
                                                    <?php switch($isSetEmail->name):

                                                        case ('shipmentScheduleChartStartYear'): ?>

                                                        <hr>
                                                            <kbd>
                                                                <?php switch($isSetEmail->value):

                                                                    case (-1): ?>
                                                                        Previous Year
                                                                    <?php break; ?>

                                                                    <?php case (0): ?>
                                                                        Present Year
                                                                    <?php break; ?>

                                                                    <?php case (1): ?>
                                                                        Next Year
                                                                    <?php break; ?>

                                                                <?php endswitch; ?>
                                                            </kbd>
                                                            <h4>Selected Year - <?php echo e(date('Y') + $isSetEmail->value); ?></h4>


                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="-1" <?php if($isSetEmail->value == "-1"): ?> checked <?php endif; ?>> Previous Year</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="0" <?php if($isSetEmail->value == "0"): ?> checked <?php endif; ?>> Present Year</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="1" <?php if($isSetEmail->value == "1"): ?> checked <?php endif; ?>> Next Year</label></div>
                                                        <hr>

                                                        <?php break; ?>

                                                        <?php case ('shipmentScheduleChartStartMonth'): ?>

                                                        <hr>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="Jan" <?php if($isSetEmail->value == "Jan"): ?> checked <?php endif; ?>> January Month</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="Jul" <?php if($isSetEmail->value == "Jul"): ?> checked <?php endif; ?>> July Month</label></div>
                                                        <hr>
                                                        Now:

                                                            <?php switch($isSetEmail->value):

                                                                case ('Jan'): ?>
                                                                    <button>January Month</button>
                                                                <?php break; ?>

                                                                <?php case ('Jun'): ?>
                                                                    <button>July Month</button>
                                                                <?php break; ?>

                                                            <?php endswitch; ?>

                                                        <?php break; ?>

                                                        <?php case ('erpBackgroundColor'): ?>

                                                        <hr>
                                                            <div><label class="border rounded-lg m-2 p-2"> Change System Color
                                                                    <br><input type="color" name="value" value="<?php echo e($isSetEmail->value); ?>" style="width: 100%;height: 80px"></label></div>
                                                        <hr>
                                                        Existing System Color: <div class="col-md-6 border rounded" style="background:<?php echo e($isSetEmail->value); ?>; height: 7rem"></div>

                                                        <?php break; ?>

                                                        <?php case ('Debug'): ?>

                                                            <hr>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="true" <?php if($isSetEmail->value == "true"): ?> checked <?php endif; ?>> True</label></div>
                                                            <div><label class="border rounded-lg m-2 p-2"><input type="radio" name="value" value="false" <?php if($isSetEmail->value == "false"): ?> checked <?php endif; ?>> False</label></div>
                                                            <hr>
                                                            Now:

                                                            <?php switch($isSetEmail->value):

                                                                case ('true'): ?>
                                                                <button>True</button>
                                                                <?php break; ?>

                                                                <?php case ('false'): ?>
                                                                <button>False</button>
                                                                <?php break; ?>

                                                            <?php endswitch; ?>

                                                        <?php break; ?>

                                                        <?php default: ?>
                                                            <input name="value" type="text" class="form-control" id="feLastName"
                                                                   placeholder="value" value="<?php echo e(isset($isSetEmail->value)?$isSetEmail->value:old('value')); ?>">

                                                    <?php endswitch; ?>

                                                <?php else: ?>
                                                    <input name="value" type="text" class="form-control" id="feLastName"
                                                           placeholder="value" value="<?php echo e(isset($isSetEmail->value)?$isSetEmail->value:old('value')); ?>">
                                                <?php endif; ?>

                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label>Status</label>
                                                <select name="status" class="form-control">
                                                    <option disabled selected="">Choose...</option>
                                                    <option value="active">Active</option>
                                                    <option value="inactive">Inactive</option>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="form-row">
                                            <div class="form-group col-md-12">
                                                <label for="feDescription">About <?php echo e($pageData['pageName']); ?></label>
                                                <textarea v-model="aboutUser" name="description" class="form-control" id="feDescription" rows="5">Lorem ipsum dolor sit amet consectetur adipisicing elit. Odio eaque, quidem, commodi soluta qui quae minima obcaecati quod dolorum sint alias, possimus illum assumenda eligendi cumque?</textarea>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-accent">Save</button>
                                    </form>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- End Default Light Table -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vue-script'); ?>
    <script>

        const data = {
            fullName: '<?php echo e(isset($isSetEmail) ? $isSetEmail->name:old('name')); ?>',
            aboutUser: '<?php echo e(isset($isSetEmail) ? $isSetEmail->description:''); ?>',
        };

        const app = new Vue({
            el: '#app',
            data,
            methods: {

            },
            beforeMount(){
                //this.departmentChange()
            },
            computed: {
                //
            }

        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\rmg_erp\resources\views/setting/create.blade.php ENDPATH**/ ?>