<?php

$pieChartMaterials = [];

?>



<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('layouts.partial.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"><?php echo e($pageData['pageName']); ?> List</h3>
            </div>

        </div>
        <div class="row">
            <div class="col-lg-12 mb-3">
                <div id="accordion" style="cursor: pointer">
                    <div class="card card-small mb-1 rounded">
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 card-link" data-toggle="collapse" href="#collapseThree">
                                Yearly Chart - <?php echo e(date('Y')); ?>

                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseThree" class="collapse show" data-parent="#accordion">
                            <div class="card-body pt-0">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item p-2">
                                        <div class="row" style="height: 400px;">
                                            <div class="col-md-12">
                                                <div id="columnChart"></div>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="card card-small mb-1 rounded">
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 card-link" data-toggle="collapse" href="#collapseFour">
                                Pending Summery
                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseFour" class="collapse show" data-parent="#accordion">
                            <div class="card-body pt-0">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item p-2">
                                        <div class="row">
                                            <?php
                                                $grandTot = [];
                                                $grandTot['qty'] = [];
                                                $grandTot['val'] = [];
                                                $grandTot['ord'] = [];
                                            ?>

                                            <?php $__currentLoopData = $allPendingOrder; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ym => $pendingOrds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-12 col-md-4 col-lg-4 mb-4">
                                                    <div class="stats-small card card-small">
                                                        <div class="card-body px-0 pb-0"><div class="chartjs-size-monitor" style="position: absolute; left: 0; top: 0; right: 0; bottom: 0; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;"><div class="chartjs-size-monitor-expand" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div></div><div class="chartjs-size-monitor-shrink" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:200%;height:200%;left:0; top:0"></div></div></div>
                                                            <div class="px-3">
                                                                <div class="">
                                                                    <span class="mb-1"><?php echo e($ym); ?> [ <?php echo e(Carbon::parse($ym)->shortEnglishMonth); ?> ]</span>

                                                                    <?php
                                                                        $qtyArr = [];
                                                                        $valArr = [];
                                                                        foreach ($pendingOrds as $pendingOrd){
                                                                            $qty = $pendingOrd->ord_quantity - $pendingOrd->shipment->sum('quantity');
                                                                            $qtyArr[] = $qty;
                                                                            $valArr[] = $pendingOrd->unit_price * $qty;

                                                                            $grandTot['qty'][] = $qty;
                                                                            $grandTot['val'][] = $pendingOrd->unit_price * $qty;
                                                                        }
                                                                    $grandTot['ord'][] = count($pendingOrds) ?? 0;
                                                                    ?>
                                                                    <table class="table table-striped table-bordered">
                                                                        <tr>
                                                                            <th>Ord</th>
                                                                            <th>Qty</th>
                                                                            <th>Value</th>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><b class="text-danger"><?php echo e(count($pendingOrds)); ?></b></td>
                                                                            <td><?php echo e(array_sum($qtyArr)); ?></td>
                                                                            <td>$<?php echo e(array_sum($valArr)); ?></td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                            <canvas height="49" class="analytics-overview-stats-small-1 chartjs-render-monitor" width="247" style="display: block; width: 247px; height: 49px;"></canvas>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-12 col-md-12 col-lg-12 mb-4">
                                                    <div class="stats-small card card-small">
                                                        <div class="card-body px-0 pb-0"><div class="chartjs-size-monitor" style="position: absolute; left: 0px; top: 0px; right: 0px; bottom: 0px; overflow: hidden; pointer-events: none; visibility: hidden; z-index: -1;"><div class="chartjs-size-monitor-expand" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:1000000px;height:1000000px;left:0;top:0"></div></div><div class="chartjs-size-monitor-shrink" style="position:absolute;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1;"><div style="position:absolute;width:200%;height:200%;left:0; top:0"></div></div></div>
                                                            <div class="px-3">
                                                                <div class="">
                                                                    <h4 class="mb-1">Grand Total</h4>
                                                                    <table class="table table-striped table-bordered">
                                                                        <tr>
                                                                            <th>Total Order</th>
                                                                            <th>Total Order Quantity</th>
                                                                            <th>Total Order Value</th>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><b class="text-danger"><?php echo e(array_sum($grandTot['ord'])); ?></b></td>
                                                                            <td><?php echo e(array_sum($grandTot['qty'])); ?></td>
                                                                            <td>$<?php echo e(array_sum($grandTot['val'])); ?></td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                                            </div>

                                                            <div id="grandPending"></div>

                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card card-small mb-1 rounded">
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 card-link" data-toggle="collapse" href="#collapseOne">
                                Chart
                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseOne" class="collapse" data-parent="#accordion">
                            <div class="card-body pt-0">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item p-2">
                                        <div class="row" style="height: 400px;">
                                            <div class="col-md-6">
                                                <div id="container"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <div id="container2"></div>
                                            </div>

                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="card card-small mb-1">
                        <div class="card-header border-bottom rounded">
                            <h6 class="m-0 collapsed card-link w-100" data-toggle="collapse" href="#collapseTwo">
                                Summery
                            </h6>
                            <div class="block-handle"></div>
                        </div>
                        <div id="collapseTwo" class="collapse" data-parent="#accordion">
                            <table class="summary-table text-capitalize">
                                <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Buyer</th>
                                    <th>Qty</th>
                                    <th>%</th>
                                    <th>Value</th>
                                    <th>%</th>
                                    <th>ShipQty</th>
                                    <th>%</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(list, key, i) in buyerWiseSummaries">
                                    <td>{{ ++i }}</td>
                                    <td>{{ key }}</td>
                                    <td>{{ list.quantity.reduce(getSum,0) }}</td>
                                    <td>{{ roundWithFrac((list.quantity.reduce(getSum,0)/orderSummerySum('quantity'))*100) }}</td>
                                    <td>{{ roundWithFrac(list.value.reduce(getSum,0)) }}</td>
                                    <td>{{ roundWithFrac((list.value.reduce(getSum,0)/orderSummerySum('value'))*100) }}</td>
                                    <td>{{ list.shipQty.reduce(getSum,0) }}</td>
                                    <td>{{ roundWithFrac((list.shipQty.reduce(getSum,0)/orderSummerySum('quantity'))*100) }}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php echo $__env->make('layouts.tools.filterFormForReport', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span><?php echo e($count); ?> <?php echo e(($count>1)?Str::plural($pageData['pageName']):$pageData['pageName']); ?> Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        
                        <h6 class="m-0">Active <?php echo e(Str::plural($pageData['pageName'])); ?></h6>
                    </div>
                    <div class="card-body p-0 text-center pre-x-scrollable">
                        <!-- Transaction History Table -->
                        <table class="main-data-table d-none text-capitalize" id="main-table">
                            <thead>
                            <tr>
                                <th>SL</th>
                                <th>ID</th>
                                <th>Buyer</th>
                                <th>OrderName</th>
                                <th>Style</th>
                                <th>StyleDesc</th>
                                <th>Image</th>
                                <th>Shipment</th>
                                <th style="background: #ffd3b0;color: #000;">RemDay</th>
                                <th>OrderQty</th>
                                <th>UnitPrice</th>
                                <th>TotValue</th>
                                <th style="background: #93a8ff;color: #000;">ShipQty</th>
                                <th>ShipValue</th>
                                <th>ShortShipVal</th>
                                <th>Curr TNA</th>
                                <th>Status</th>
                                <th>CM</th>
                                <th>Yarn Consumption</th>
                                <th>SMV</th>

                                <th>Cutting</th>
                                <th>Cutting%</th>
                                <th>SwingIn</th>
                                <th>SwingOut</th>
                                <th>Iron</th>
                                <th>Poly</th>
                                
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $pieChartMaterials[$order->buyer->name]['shipQty'][] = $shipmentQty = $order->shipment->sum('quantity');
                                    $pieChartMaterials[$order->buyer->name]['quantity'][] = $afterShipmentQty = $order->ord_quantity - $shipmentQty;
                                    $pieChartMaterials[$order->buyer->name]['value'][] = $afterShipmentQty * $order->unit_price;

                                    $dateOfShip = $order->date_of_ship;

                                    $dateForHumans = Carbon::parse($dateOfShip)->diffForHumans(Carbon::now());
                                    $diff = -Carbon::parse($dateOfShip)->diffInDays(Carbon::now(), false)
                                ?>
                            <tr>
                                                  <td>1</td>
                                              <td><?php echo e($order->id); ?></td>
                                               <td><?php echo e($order->buyer->name); ?></td>
                                          <td><?php echo e($order->name); ?></td>
                                          <td><?php echo e($order->style); ?></td>
                                          <td><?php echo e($order->style_desc); ?></td>
                                  <td><img class="zoom" width="50" src="<?php echo e($order->getGarmentsPicture()); ?>" alt=""></td>
                                       <td><?php echo e($dateOfShip); ?></td>
                                             <td> <div class="badge <?php echo e(($diff<=10)?(($diff<0)?'badge-danger':'badge-warning'):'badge-info'); ?>"><?php echo e($diff); ?></div><br> <?php echo e(str_replace(['before', 'after'], ['delay', 'remain'], $dateForHumans)); ?></td>
                                           <td><?php echo e($afterShipmentQty); ?></td>
                                          <td><?php echo e($order->unit_price); ?></td>
                                         <td><?php echo e($totalValue = $afterShipmentQty * $order->unit_price); ?></td>
                                            <td><?php echo e($shipmentQty); ?></td>
                                          <td><?php echo e($shipmentQty*$order->unit_price); ?></td>
                                    <td><?php echo e($shipmentQty?$shipmentQty*$order->unit_price-$totalValue:null); ?></td>
                                        <td><?php echo e($order->status->name ?? null); ?></td>
                                        <td style="<?php if($order->statuses=='ShipOut'): ?> background: #794d53; color:#fff; <?php elseif($order->statuses=='Partial'): ?> background: #797750; color:#fff; <?php endif; ?>"><?php echo e($order->statuses); ?></td>
                                <td><?php echo e($order->budget->cm ?? null); ?></td>
                  <td><?php echo e($order->budget->yarn_consumption ?? null); ?></td>
                                                 <td><?php echo e($order->smv); ?></td>
                                               

                                             <td><?php echo e($chartMaterials['cutting'][] = $order->cutting->sum('quantity')); ?></td>
                                                                <?php
                                                                    $ordQty = $order->ord_quantity - $order->shipment->sum('quantity');
                                                                    if ($ordQty != 0){
                                                                        $cutPerc = round(($order->cutting->sum('quantity') - $ordQty)/$ordQty*100, 2);
                                                                        $str = '%';
                                                                    } else {
                                                                        $cutPerc = null;
                                                                        $str = 'Order Qty is 0';
                                                                    }
                                                                ?>
                                             <td class="<?php if($cutPerc > 5): ?> bg-danger text-light <?php endif; ?>"> <?php echo e($cutPerc); ?> <?php echo e($str); ?></td>
                                            <td><?php echo e($chartMaterials['swingIn'][] = $order->swingIn->sum('quantity')); ?></td>
                                           <td><?php echo e($chartMaterials['swingOut'][] = $order->swingOut->sum('quantity')); ?></td>
                                                <td><?php echo e($chartMaterials['iron'][] = $order->iron->sum('quantity')); ?></td>
                                             <td><?php echo e($chartMaterials['packing'][] = $order->packing->sum('quantity')); ?></td>

                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">
                                        
                                        <a class="btn btn-white" href="<?php echo e(route($pageData['routeFirstName'].'-show', [$order->id, 'page' => 'history'])); ?>">
                                            <i class="material-icons">&#xE870;</i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th>SL</th>
                                <th>ID</th>
                                <th>Buyer</th>
                                <th>OrderName</th>
                                <th>Style</th>
                                <th>StyleDesc</th>
                                <th>Image</th>
                                <th>Shipment</th>
                                <th style="background: #ffd3b0;color: #000;">RemDay</th>
                                <th>OrderQty</th>
                                <th>UnitPrice</th>
                                <th>TotValue</th>
                                <th style="background: #93a8ff;color: #000;">ShipQty</th>
                                <th>ShipValue</th>
                                <th>ShortShipVal</th>
                                <th>Curr TNA</th>
                                <th>Status</th>
                                <th>CM</th>
                                <th>Yarn Consumption</th>
                                <th>SMV</th>

                                <th>Cutting</th>
                                <th>Cutting%</th>
                                <th>SwingIn</th>
                                <th>SwingOut</th>
                                <th>Iron</th>
                                <th>Poly</th>
                                
                                <th>Action</th>
                            </tr>
                            </tbody>
                            <tfoot>
                            <tr>
                                <th>SL</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th style="background: #93a8ff;color: #000;"></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th> 
                                
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                            </tfoot>
                        </table>
                        <!-- End Transaction History Table -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="promo-popup animated bounceIn" style="padding: 10px; border: 2px solid #898989; background: rgba(255,255,255,0.82); right: 10px;">

        <div>
            <a href="#accordion">
            <span class="close">
                <i class="material-icons">pie_chart</i>
            </span>
            </a>
        </div>


        <div>
            <a href="#search-area">
            <span class="close">
                <i class="material-icons">format_align_left</i>
            </span>
            </a>
        </div>


    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vue-script'); ?>

    
    <?php

    $orderModel = new App\Order();
    $pendingOrdersYears = date('Y');

    ?>
    

    <?php echo $__env->make('js/script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        function dataTableFooterSum(obj) {
            let tbl = obj.table;
            [9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 22, 23, 24, 25].forEach(function (col) {
                $(tbl.column(col).footer()).html(
                    roundWithFrac(tbl.column(col).data().sum())
                );
            });

            /*custom sum footer*/
            let totVal = $(tbl.column(11).footer()).text();
            let totOrdQty = $(tbl.column(9).footer()).text();
            let totCm = $(tbl.column(17).footer()).text();
            //let totYrn = $(tbl.column(18).footer()).text();


            //console.log(totYrn);
            //console.log(tbl.column(10).footer());

            $(tbl.column(10).footer()).html(
                roundWithFrac(totVal/totOrdQty)
            );
            $(tbl.column(17).footer()).html(
                roundWithFrac(totCm/totOrdQty * 12)
            );
            /*$(tbl.column(20).footer()).html(
                roundWithFrac((totYrn * 12) / totOrdQty)
            );*/
            /*custom sum footer*/
        }


        function piData(type) {
            let $pieChartMaterials = JSON.parse('<?php echo e(json_encode($pieChartMaterials)); ?>'.replace(/&quot;/g,'"'));

            return Object.keys($pieChartMaterials).map(function (k) {
                let val = $pieChartMaterials[k][type].reduce(function (qty, pilot) {
                    return qty + pilot
                },0);
                return {name: k, y:val};
            });
        }

        //summary-table
        vm.buyerWiseSummaries = JSON.parse('<?php echo e(json_encode($pieChartMaterials)); ?>'.replace(/&quot;/g,'"'));

        let piObj = {
            elm: 'container',
            seriesName: 'Quantity',
            heading: 'Buyer Wise Pending Quantity',
        };
        let piObj2 = {
            elm: 'container2',
            seriesName: 'Value',
            heading: 'Buyer Wise Pending Value',
        };

        Highcharts.chart('columnChart', {

            chart: {
                type: 'column'
            },

            title: {
                text: 'Monthly Order'
            },

            xAxis: {
                categories: [
                    <?php $__currentLoopData = $orderModel->pendingOrderYearWiseMonth( $pendingOrdersYears )[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($month); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
            },

            yAxis: [{
                title: {
                    text: 'Quantity axis'
                }
            },
                {
                    opposite: true,
                    title: {
                        text: 'Value axis'
                    }
                }],

            plotOptions: {
                series: {
                    borderWidth: 0,
                    /*dataLabels: {
                        enabled: true,
                        format: '{point.y:.f}'
                    }*/
                },
                column: {
                    pointPadding: 0.05,
                    borderRadius: 3
                }
            },

            series: [{
                name: 'Quantity',
                data: [
                    <?php $__currentLoopData = $orderModel->pendingOrderYearWiseMonth( $pendingOrdersYears )[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e(array_sum($orderModel->pendingOrderYearWiseMonth( $pendingOrdersYears )[1][$month] ?? [])); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            }, {
                name: 'Value',
                data: [
                    <?php $__currentLoopData = $orderModel->pendingOrderYearWiseMonth( $pendingOrdersYears )[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $monthlyOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e(array_sum($orderModel->pendingOrderYearWiseMonth( $pendingOrdersYears )[2][$month] ?? [])); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                yAxis: 1
            }],
            credits: {
                enabled: false
            },

        });

        Highcharts.chart('grandPending', {
            chart: {
                type: 'areaspline'
            },
            title: {
                text: 'Pending Order Timeline'
            },
            legend: {
                layout: 'vertical',
                align: 'left',
                verticalAlign: 'top',
                x: 150,
                y: 100,
                floating: true,
                borderWidth: 1,
                backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'
            },
            xAxis: {
                categories: [
                    <?php $__currentLoopData = $allPendingOrder; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ym => $pendingOrds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($ym); ?>',
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                plotBands: [{ // visualize the weekend
                    from: 4.5,
                    to: 6.5,
                    color: 'rgba(68, 170, 213, .2)'
                }]
            },
            yAxis: {
                title: {
                    text: 'Pending Quantity'
                }
            },
            tooltip: {
                shared: true,
            },
            credits: {
                enabled: false
            },
            plotOptions: {
                areaspline: {
                    fillOpacity: 0.5
                }
            },
            series: [{
                name: 'Quantity',
                data: [
                    <?php $__currentLoopData = $allPendingOrder; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ym => $pendingOrds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $qtyArr = [];
                    foreach ($pendingOrds as $pendingOrd){
                        $qty = $pendingOrd->ord_quantity - $pendingOrd->shipment->sum('quantity');
                        $qtyArr[] = $qty;
                    }
                    ?>
                    <?php echo e(array_sum($qtyArr)); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            }, {
                name: 'Value',
                data: [
                    <?php $__currentLoopData = $allPendingOrder; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ym => $pendingOrds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $valArr = [];
                    foreach ($pendingOrds as $pendingOrd){
                        $qty = $pendingOrd->ord_quantity - $pendingOrd->shipment->sum('quantity');
                        $valArr[] = $pendingOrd->unit_price * $qty;
                    }
                    ?>
                    <?php echo e(array_sum($valArr)); ?>,
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            }]
        });

        chartNSummery(piObj, piData('quantity'));
        chartNSummery(piObj2, piData('value'));

        function chartNSummery($piObj, data) {
            // Build the chart
            Highcharts.chart($piObj.elm, {
                // Radialize the colors
                colors: Highcharts.map(Highcharts.getOptions().colors, function (color) {
                    return {
                        radialGradient: {
                            cx: 0.5,
                            cy: 0.3,
                            r: 0.7
                        },
                        stops: [
                            [0, color],
                            [1, Highcharts.Color(color).brighten(-0.3).get('rgb')] // darken
                        ]
                    };
                }),
                chart: {
                    plotBackgroundColor: null,
                    plotBorderWidth: null,
                    plotShadow: false,
                    type: 'pie'
                },
                title: {
                    text: $piObj.heading
                },
                tooltip: {
                    pointFormat: '{series.name}: <b>{point.y}</b>'
                },
                plotOptions: {
                    pie: {
                        allowPointSelect: true,
                        cursor: 'pointer',
                        dataLabels: {
                            enabled: true,
                            format: '<b>{point.name}</b>: {point.percentage:.1f} %',
                            style: {
                                color: (Highcharts.theme && Highcharts.theme.contrastTextColor) || 'black'
                            },
                            connectorColor: 'silver'
                        }
                    }
                },
                series: [{
                    name: $piObj.seriesName,
                    data
                }],
                credits: {
                    enabled: false
                },
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\rmg_erp\resources\views/orderPending/index.blade.php ENDPATH**/ ?>