

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('layouts.partial.notice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-4 mb-sm-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"><?php echo e($pageData['pageName']); ?> Analytics <?php echo e(ucwords(request()->get('page'))); ?></h3>
            </div>
            <div class="col-12 col-sm-4 d-flex align-items-center">
                <div class="btn-group btn-group-sm btn-group-toggle d-inline-flex mb-4 mb-sm-0 mx-auto" role="group" aria-label="Page actions">

                    <a href="<?php echo e(route($pageData['routeFirstName'].'-show', $order->id)); ?>"
                       class="btn btn-white <?php echo e((request()->get('page') == null)?'active':null); ?>"> Order </a>

                    <a href="<?php echo e(route($pageData['routeFirstName'].'-show', [$order->id, 'page' => 'budget'])); ?>"
                       class="btn btn-white <?php echo e((request()->get('page') == 'budget')?'active':null); ?>"> Budget </a>

                    <a href="<?php echo e(route($pageData['routeFirstName'].'-show', [$order->id, 'page' => 'budget_post_cost'])); ?>"
                       class="btn btn-white <?php echo e((request()->get('page') == 'budget_post_cost')?'active':null); ?>"> BudgetPost </a>

                    <a href="<?php echo e(route($pageData['routeFirstName'].'-show', [$order->id, 'page' => 'manufacturing'])); ?>"
                       class="btn btn-white <?php echo e((request()->get('page') == 'manufacturing')?'active':null); ?>"> Manufacturing </a>

                    <a href="<?php echo e(route($pageData['routeFirstName'].'-show', [$order->id, 'page' => 'history'])); ?>"
                       class="btn btn-white <?php echo e((request()->get('page') == 'history')?'active':null); ?>"> History </a>

                </div>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Small Stats Blocks -->
        <?php if(request()->get('page') == 'manufacturing'): ?>
            <?php echo $__env->make('layouts.orderDetails.order_manufacturing_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php elseif(request()->get('page') == 'budget'): ?>
            <?php echo $__env->make('layouts.orderDetails.order_budget_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php elseif(request()->get('page') == 'budget_post_cost'): ?>
            <?php echo $__env->make('layouts.orderDetails.order_budget_post_cost_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php elseif(request()->get('page') == 'history'): ?>
            <?php echo $__env->make('layouts.orderDetails.order_history_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php else: ?>
            <?php echo $__env->make('layouts.orderDetails.order_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vue-script'); ?>
    <script>
        function printOrderInfo(orderId){
            let url = "<?php echo e(route('order-print', '::orderID')); ?>";
            url = url.replace('::orderID', orderId);

            let WinPrint = window.open(url, '', 'left=0,top=0,width=800,height=900,toolbar=0,scrollbars=0,status=0');

            WinPrint.document.close();
            WinPrint.focus();
            WinPrint.print();
            WinPrint.onafterprint = function(){
                //WinPrint.close();
            };
        }

        function simulateKey(iElement) {
            $( iElement ).focus();
            let e = jQuery.Event("keyup");
            e.which = 39;
            e.keyCode = 39;
            e.charCode = 0;
            $( iElement ).trigger(e);
        }

        $(function () {
            let laravelBelongsName;
            let $eventSelect = $('.select2-box').select2({
                placeholder: "Select...",
            });

            $eventSelect.on("select2:open", function () {

                let laravelModelName = $(this).attr('laravel-model');
                laravelBelongsName = $(this).attr('laravel-belongs') || '';
                let url = '<?php echo e(route('api-get-select-dropdown-data')); ?>/'+laravelModelName+'/'+laravelBelongsName;
                axios
                    .get(url)
                    .then(response => {
                        $(this).html('<option>');

                        (response.data).forEach(val => {
                                laravelBelongsName = snakeCase(laravelBelongsName);
                                let name = capitalizeFirstLetter(val.name);

                                let sanitizeVal = val[laravelBelongsName]?{id:val.id, text: name+' ('+capitalizeFirstLetter(val[laravelBelongsName].name)+')'}: {id:val.id, text:name};

                                $(this).append('<option value="'+sanitizeVal.id+'">'+sanitizeVal.text+'</option>');
                                simulateKey($('.select2-search__field'));
                            });

                        }
                    )
                ;
            });

        });

        const data = {
            userImg: '<?php echo e(isset($getUser) ? $getUser->GetProfilePicture():asset('profile-pic/garments/garment.png')); ?>',
            fullName: '<?php echo e(isset($getUser) ? $getUser->name:old('name')); ?>',
            buyerName: '<?php echo e(isset($getUser) ? $getUser->role->name:''); ?>',
            aboutUser: '<?php echo e(isset($getUser) ? $getUser->description:''); ?>',
            teams: [],
            teamsPhpView: true,
        };

        const app = new Vue({
            el: '#app',
            data,
            methods: {

            },
            mounted(){

            },
            computed: {


            }

        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\rmg_erp\resources\views/layouts/orderDetails/show.blade.php ENDPATH**/ ?>