<?php

namespace App\Http\Controllers;

use App\BusinessGap;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BusinessGapController extends Controller
{
    public $_profile_pic_folder = 'profile-pic/garments';
    public $pageData = [];

    public function __construct()
    {
        $this->pageData = [
            'no' => 0,
            'pageName' => 'Business Gap',
            'routeFirstName' => 'business-gap',
            'ignoreColsInExport' => '[0]',
        ];

        view()->share('pageData', $this->pageData);

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Http\Response|\Illuminate\View\View
     */
    public function index()
    {
        $commercialController = new CommercialController();
        $paymentDueValuesCompact = $commercialController->commercialExpenseFieldPaymentDueValues();

        $businessGap = BusinessGap::first();
        //dd($businessGap);
        $businessGapSum = array_sum([
            $businessGap->receivable_from_cash_lc ?? 0,
            $businessGap->usd_ac_balance ?? 0,
            $businessGap->cash_incentive ?? 0,
            $businessGap->fdr ?? 0,
            $businessGap->usd_ac ?? 0,
            $businessGap->ac_receivable ?? 0,
            $businessGap->yarn_block_lc ?? 0,
            $businessGap->others ?? 0,
            $businessGap->stock_or_inventory ?? 0,
        ]);
        $compact = $paymentDueValuesCompact;
        $compact += compact('businessGap', 'businessGapSum');

        view()->share('pageData', $this->pageData);

        return view('businessGap.index', $compact);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $isSetModel = BusinessGap::first();

        return view('businessGap.create', compact('isSetModel'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, BusinessGap $businessGap=null)
    {
        //dd($request->all());
        $request->validate([
            "receivable_from_cash_lc" => "numeric|nullable",
            "usd_ac_balance" => "numeric|nullable",
            "cash_incentive" => "numeric|nullable",
            "fdr" => "numeric|nullable",
            "usd_ac" => "numeric|nullable",
            "ac_receivable" => "numeric|nullable",
            "yarn_block_lc" => "numeric|nullable",
            "others" => "numeric|nullable",
            "stock_or_inventory" => "numeric|nullable",
            "description" => "",
        ]);

        ini_set('max_execution_time', 1600);

        $loggedUser = Auth::user();

        $businessGap = BusinessGap::first();

        $model = new BusinessGap();

        if ($businessGap) $model = $businessGap;

        $model->user_id =                   $loggedUser->id;

        $model->receivable_from_cash_lc = $request['receivable_from_cash_lc'];
        $model->usd_ac_balance =          $request['usd_ac_balance'];
        $model->cash_incentive =          $request['cash_incentive'];
        $model->fdr =                     $request['fdr'];
        $model->usd_ac =                  $request['usd_ac'];
        $model->ac_receivable =           $request['ac_receivable'];
        $model->yarn_block_lc =           $request['yarn_block_lc'];
        $model->others =                  $request['others'];
        $model->stock_or_inventory =      $request['stock_or_inventory'];
        $model->description =             $request['description'];

        $model->save();

        return redirect()->route($this->pageData['routeFirstName'].'-list', 'id='.$model->id)->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\BusinessGap  $businessGap
     * @return \Illuminate\Http\Response
     */
    public function show(BusinessGap $businessGap)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\BusinessGap  $businessGap
     * @return \Illuminate\Http\Response
     */
    public function edit(BusinessGap $businessGap)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\BusinessGap  $businessGap
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, BusinessGap $businessGap)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\BusinessGap  $businessGap
     * @return \Illuminate\Http\Response
     */
    public function destroy(BusinessGap $businessGap)
    {
        //
    }
}
