<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Role, App\Operation;

class RoleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = Role::all();
        return view('role.index', compact('roles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return back();

        return view('role.create')
            ->withOperations(Operation::all())
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        return back();
        //dd($request->all());
        $request->validate([
            'name' => 'required|unique:roles',
            'code' => 'required|unique:roles',
            'dashboard' => 'required',
            'operation' => 'required',
        ]);
        $role = new Role();
        $role->name = $request->name;
        $role->code = $request->code;
        $role->dashboard = $request->dashboard;
        $role->save();
        $role->operations()->sync($request->operation);

        return redirect()->route('role-list');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Role $role)
    {
        return back();
        return view('role.create')
            ->withOperations(Operation::all())
            ->withRole($role)
            ;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return back();
        return $id;
    }
}
