<?php

namespace App\Http\Middleware;

use Closure;

class RoleCheckMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $args = func_get_args();

        unset($args[0],$args[1]); // unset argument "$request, Closure $next" from method parameters

        //dd($args);

        $role_check = auth()->user()->isUserCanAccess($args); // this arguments come from route

        if ($role_check) {
            return $next($request);
        }

        return back()->with(['fail'=>'Unauthorised action! please inform your superior.']);
    }
}
