@extends('layouts.master')
@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Dashboard</span>
                <h3 class="page-title">Overview</h3>
                <br>
                <h4 class="text-danger"><b>Time</b>: {{ date('d-m-Y') }} ({{ date('M') }})
                    <small class="text-accent"><b class="time-show"></b></small>
                </h4>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Small Stats Blocks -->
        <div class="row">
            <div class="col-lg col-md-6 col-sm-6 mb-4">
                <div class="stats-small stats-small--1 card card-small">
                    <div class="card-body p-0 d-flex">
                        <div class="d-flex flex-column m-auto">
                            <div class="stats-small__data text-center">
                                <a href="{{ route('order-list', 'direct=true') }}">
                                    <span class="stats-small__label text-uppercase">Orders</span>
                                    <h6 class="stats-small__value count my-3">{{ $ordersCount }}</h6>
                                </a>
                            </div>
                            <div class="stats-small__data">
                                <span class="stats-small__percentage stats-small__percentage--increase">0%</span>
                            </div>
                        </div>
                        <canvas height="120" class="blog-overview-stats-small-1"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-lg col-md-6 col-sm-6 mb-4">
                <div class="stats-small stats-small--1 card card-small bg-info">
                    <div class="card-body p-0 d-flex">
                        <div class="d-flex flex-column m-auto">
                            <div class="stats-small__data text-center">
                                <a href="{{ route('order-pending-list') }}">
                                    <span class="stats-small__label text-uppercase text-white">Pending Orders</span>
                                    <h6 class="stats-small__value count my-3 text-white">{{ $pendingOrdersCount }}</h6>
                                </a>
                            </div>
                            <div class="stats-small__data">
                                <span class="stats-small__percentage stats-small__percentage--increase">0%</span>
                            </div>
                        </div>
                        <canvas height="120" class="blog-overview-stats-small-1"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg col-md-6 col-sm-6 mb-4">
                <div class="stats-small stats-small--1 card card-small">
                    <div class="card-body p-0 d-flex">
                        <div class="d-flex flex-column m-auto">
                            <div class="stats-small__data text-center">
                                <a href="{{ route('buyer-list') }}">
                                    <span class="stats-small__label text-uppercase">Buyers</span>
                                    <h6 class="stats-small__value count my-3">{{ $buyersCount }}</h6>
                                </a>
                            </div>
                            <div class="stats-small__data">
                                <span class="stats-small__percentage stats-small__percentage--increase">0%</span>
                            </div>
                        </div>
                        <canvas height="120" class="blog-overview-stats-small-2"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg col-md-4 col-sm-6 mb-4">
                <div class="stats-small stats-small--1 card card-small">
                    <div class="card-body p-0 d-flex">
                        <div class="d-flex flex-column m-auto">
                            <div class="stats-small__data text-center">
                                <span class="stats-small__label text-uppercase">Productions</span>
                                <h6 class="stats-small__value count my-3">{{ $productionCount }}</h6>
                            </div>
                            <div class="stats-small__data">
                                <span class="stats-small__percentage stats-small__percentage--decrease">0%</span>
                            </div>
                        </div>
                        <canvas height="120" class="blog-overview-stats-small-3"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg col-md-4 col-sm-6 mb-4">
                <div class="stats-small stats-small--1 card card-small">
                    <div class="card-body p-0 d-flex">
                        <div class="d-flex flex-column m-auto">
                            <div class="stats-small__data text-center">
                                <span class="stats-small__label text-uppercase">Shipments</span>
                                <h6 class="stats-small__value count my-3">{{ $shipmentCount }}</h6>
                            </div>
                            <div class="stats-small__data">
                                <span class="stats-small__percentage stats-small__percentage--increase">0%</span>
                            </div>
                        </div>
                        <canvas height="120" class="blog-overview-stats-small-4"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg col-md-4 col-sm-12 mb-4">
                <div class="stats-small stats-small--1 card card-small">
                    <div class="card-body p-0 d-flex">
                        <div class="d-flex flex-column m-auto">
                            <div class="stats-small__data text-center">
                                <a href="{{ route('user-list') }}">
                                    <span class="stats-small__label text-uppercase">Users</span>
                                    <h6 class="stats-small__value count my-3">{{ $usersCount }}</h6>
                                </a>
                            </div>
                            <div class="stats-small__data">
                                <span class="stats-small__percentage stats-small__percentage--decrease">0%</span>
                            </div>
                        </div>
                        <canvas height="120" class="blog-overview-stats-small-5"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Small Stats Blocks -->
        <div class="row">
            <!-- Users Stats -->
            <div class="col-lg-8 col-md-12 col-sm-12 mb-4">
                <div class="card card-small">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">Users</h6>
                    </div>
                    <div class="card-body pt-0">
                        <div class="row border-bottom py-2 bg-light">
                            <div class="col-12 col-sm-6">
                                <div id="blog-overview-date-range" class="input-daterange input-group input-group-sm my-auto ml-auto mr-auto ml-sm-auto mr-sm-0" style="max-width: 350px;">
                                    <input type="text" class="input-sm form-control" name="start" placeholder="Start Date" id="blog-overview-date-range-1">
                                    <input type="text" class="input-sm form-control" name="end" placeholder="End Date" id="blog-overview-date-range-2">
                                    <span class="input-group-append">
                            <span class="input-group-text">
                              <i class="material-icons">î¤–</i>
                            </span>
                          </span>
                                </div>
                            </div>
                            <div class="col-12 col-sm-6 d-flex mb-2 mb-sm-0">
                                <button type="button" class="btn btn-sm btn-white ml-auto mr-auto ml-sm-auto mr-sm-0 mt-3 mt-sm-0">View Full Report &rarr;</button>
                            </div>
                        </div>
                        <canvas height="130" style="max-width: 100% !important;" class="blog-overview-users"></canvas>
                    </div>
                </div>
            </div>
            <!-- End Users Stats -->
            <!-- Users By Device Stats -->
            <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
                <div class="card card-small h-100">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">Users by device</h6>
                    </div>
                    <div class="card-body d-flex py-0">
                        <canvas height="220" class="blog-users-by-device m-auto"></canvas>
                    </div>
                    <div class="card-footer border-top">
                        <div class="row">
                            <div class="col">
                                <select class="custom-select custom-select-sm" style="max-width: 130px;">
                                    <option selected>Last Week</option>
                                    <option value="1">Today</option>
                                    <option value="2">Last Month</option>
                                    <option value="3">Last Year</option>
                                </select>
                            </div>
                            <div class="col text-right view-report">
                                <a href="#">Full report &rarr;</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Users By Device Stats -->

            <!-- Discussions Component -->
            <div class="col-lg-5 col-md-12 col-sm-12 mb-4">
                <div class="card card-small blog-comments">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">Discussions</h6>
                    </div>
                    <div class="card-body p-0">
                        <div class="blog-comments__item d-flex p-3">
                            <div class="blog-comments__avatar mr-3">
                                <img src="{{ asset('dashboard/') }}/images/avatars/1.jpg" alt="User avatar" /> </div>
                            <div class="blog-comments__content">
                                <div class="blog-comments__meta text-muted">
                                    <a class="text-secondary" href="#">James Johnson</a> on
                                    <a class="text-secondary" href="#">Hello World!</a>
                                    <span class="text-muted">â€“ 3 days ago</span>
                                </div>
                                <p class="m-0 my-1 mb-2 text-muted">Well, the way they make shows is, they make one show ...</p>
                                <div class="blog-comments__actions">
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" class="btn btn-white">
                              <span class="text-success">
                                <i class="material-icons">check</i>
                              </span> Approve </button>
                                        <button type="button" class="btn btn-white">
                              <span class="text-danger">
                                <i class="material-icons">clear</i>
                              </span> Reject </button>
                                        <button type="button" class="btn btn-white">
                              <span class="text-light">
                                <i class="material-icons">more_vert</i>
                              </span> Edit </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="blog-comments__item d-flex p-3">
                            <div class="blog-comments__avatar mr-3">
                                <img src="{{ asset('dashboard/') }}/images/avatars/2.jpg" alt="User avatar" /> </div>
                            <div class="blog-comments__content">
                                <div class="blog-comments__meta text-muted">
                                    <a class="text-secondary" href="#">James Johnson</a> on
                                    <a class="text-secondary" href="#">Hello World!</a>
                                    <span class="text-muted">â€“ 4 days ago</span>
                                </div>
                                <p class="m-0 my-1 mb-2 text-muted">After the avalanche, it took us a week to climb out. Now...</p>
                                <div class="blog-comments__actions">
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" class="btn btn-white">
                              <span class="text-success">
                                <i class="material-icons">check</i>
                              </span> Approve </button>
                                        <button type="button" class="btn btn-white">
                              <span class="text-danger">
                                <i class="material-icons">clear</i>
                              </span> Reject </button>
                                        <button type="button" class="btn btn-white">
                              <span class="text-light">
                                <i class="material-icons">more_vert</i>
                              </span> Edit </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="blog-comments__item d-flex p-3">
                            <div class="blog-comments__avatar mr-3">
                                <img src="{{ asset('dashboard/') }}/images/avatars/3.jpg" alt="User avatar" /> </div>
                            <div class="blog-comments__content">
                                <div class="blog-comments__meta text-muted">
                                    <a class="text-secondary" href="#">James Johnson</a> on
                                    <a class="text-secondary" href="#">Hello World!</a>
                                    <span class="text-muted">â€“ 5 days ago</span>
                                </div>
                                <p class="m-0 my-1 mb-2 text-muted">My money's in that office, right? If she start giving me...</p>
                                <div class="blog-comments__actions">
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" class="btn btn-white">
                              <span class="text-success">
                                <i class="material-icons">check</i>
                              </span> Approve </button>
                                        <button type="button" class="btn btn-white">
                              <span class="text-danger">
                                <i class="material-icons">clear</i>
                              </span> Reject </button>
                                        <button type="button" class="btn btn-white">
                              <span class="text-light">
                                <i class="material-icons">more_vert</i>
                              </span> Edit </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer border-top">
                        <div class="row">
                            <div class="col text-center view-report">
                                <button type="submit" class="btn btn-white">View All Comments</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Discussions Component -->
            <!-- Top Buyers Component -->
            <div class="col-lg-3 col-md-12 col-sm-12 mb-4">
                <div class="card card-small">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">Buyers Order</h6>
                    </div>
                    <div class="card-body p-0">
                        <ul class="list-group list-group-small list-group-flush">
                            @foreach($buyers as $buyer)
                            <li class="list-group-item d-flex px-3">
                                <span class="text-semibold text-fiord-blue">{{ $buyer->name }}</span>
                                <span class="ml-auto text-right text-semibold text-reagent-gray">{{ $buyer->order->count() }}</span>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="card-footer border-top">
                        <div class="row">
                            <div class="col">
                                <select class="custom-select custom-select-sm">
                                    <option selected>Last Week</option>
                                    <option value="1">Today</option>
                                    <option value="2">Last Month</option>
                                    <option value="3">Last Year</option>
                                </select>
                            </div>
                            <div class="col text-right view-report">
                                <a href="#">Full report &rarr;</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Top Buyers Component -->

            <!-- Top User Activities Component -->
            <div class="col-lg-3 col-md-12 col-sm-12 mb-4">
                <div class="card card-small">
                    <div class="card-header border-bottom">
                        <h6 class="m-0">User Order</h6>
                    </div>
                    <div class="card-body p-0">
                        <ul class="list-group list-group-small list-group-flush">
                            @foreach($users as $user)
                            <li class="list-group-item d-flex px-3">
                                <span class="text-semibold text-fiord-blue">{{ $user->name }}</span>
                                <span class="ml-auto text-right text-semibold text-reagent-gray">{{ $user->order->count() }}</span>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="card-footer border-top">
                        <div class="row">
                            <div class="col">
                                <select class="custom-select custom-select-sm">
                                    <option selected>Last Week</option>
                                    <option value="1">Today</option>
                                    <option value="2">Last Month</option>
                                    <option value="3">Last Year</option>
                                </select>
                            </div>
                            <div class="col text-right view-report">
                                <a href="#">Full report &rarr;</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Top User Activities Component -->
        </div>
    </div>

    <script>
        function startTime() {
            var today = new Date();
            var h = today.getHours();
            var m = today.getMinutes();
            var s = today.getSeconds();
            m = checkTime(m);
            s = checkTime(s);
            document.querySelector('.time-show').innerHTML =
                h + ":" + m + ":" + s;
            var t = setTimeout(startTime, 500);
        }
        function checkTime(i) {
            if (i < 10) {i = "0" + i};  // add zero in front of numbers < 10
            return i;
        }

        startTime()
    </script>

@endsection
