<div class="row" id="search-area">
    <div class="col-lg-12 mb-1">
        <div class="card card-small">
            <ul class="list-group list-group-flush">
                <li class="list-group-item p-2">
                    <div class="row">
                        <div class="col-sm-12 col-md-12">

                            {{--search form--}}
                            <form action="#search-area">
                                <div class="row mb-2">

                                    <div class="col-md-3">

                                        <div class="row">

                                            <div class="col-md-5">
                                                <input type="hidden" id="filterYear" value="{{ $filterYear ?? '' }}">
                                                <select class="select2-box-manual-year form-control yr-select" name="filterYear">
                                                    <option value="2015">2015</option>
                                                    <option value="2016">2016</option>
                                                    <option value="2017">2017</option>
                                                    <option value="2018">2018</option>
                                                    <option value="2019">2019</option>
                                                    <option value="2020" selected>2020</option>
                                                    <option value="2021">2021</option>
                                                    <option value="2022">2022</option>
                                                    <option value="2023">2023</option>
                                                    <option value="2024">2024</option>
                                                </select>
                                            </div>

                                            <div class="col-md-7 p-0">
                                                <select class="select2-box-manual form-control" name="date_type">
                                                    <option value="date_of_ship" {{ (Request::get('date_type') == 'date_of_ship') ? 'selected' : null }}>ShipDate</option>
                                                    <option value="order_accept_date" {{ (Request::get('date_type') == 'order_accept_date') ? 'selected' : null }}>AcceptDate</option>
                                                </select>
                                            </div>

                                        </div>

                                    </div>

                                    <div class="col-md-9">
                                        <button onclick="dateAppend('-01-01', '-01-31')" type="button" class="btn btn-success">Jan</button>
                                        <button onclick="dateAppend('-02-01', '-02-28')" type="button" class="btn btn-success">Fab</button>
                                        <button onclick="dateAppend('-03-01', '-03-31')" type="button" class="btn btn-success">Mar</button>
                                        <button onclick="dateAppend('-04-01', '-04-30')" type="button" class="btn btn-success">Apr</button>
                                        <button onclick="dateAppend('-05-01', '-05-31')" type="button" class="btn btn-success">May</button>
                                        <button onclick="dateAppend('-06-01', '-06-30')" type="button" class="btn btn-success">Jun</button>
                                        <button onclick="dateAppend('-07-01', '-07-31')" type="button" class="btn btn-success">Jul</button>
                                        <button onclick="dateAppend('-08-01', '-08-31')" type="button" class="btn btn-success">Aug</button>
                                        <button onclick="dateAppend('-09-01', '-09-30')" type="button" class="btn btn-success">Sep</button>
                                        <button onclick="dateAppend('-10-01', '-10-31')" type="button" class="btn btn-success">Oct</button>
                                        <button onclick="dateAppend('-11-01', '-11-30')" type="button" class="btn btn-success">Nov</button>
                                        <button onclick="dateAppend('-12-01', '-12-31')" type="button" class="btn btn-success">Dec</button>
                                    </div>

                                </div>
                                <div class="row flex-row-reverse">
                                    {{--From and to--}}
                                    <div class="col-md-3">
                                        <div style="max-width: 240px" id="analytics-overview-date-range" class="input-daterange input-group input-group-md ml-auto">
                                            <input value="{{ $from }}" autocomplete="off" type="text" class="input-sm form-control" name="from" placeholder="Start Date">
                                            <input value="{{ $to }}" autocomplete="off" type="text" class="input-sm form-control" name="to" placeholder="End Date">
                                        </div>
                                    </div>
                                    {{--End From and to--}}

                                    <div class="form-group col-md-2 pr-0">
                                        <a href="{{ route($pageData['routeFirstName'].'-list') }}#search-area" class="mb-2 ml-4 btn btn-dark">All</a>
                                        &nbsp;
                                        <a href="{{ route($pageData['routeFirstName'].'-list', 'direct=true') }}#search-area" class="mb-2 btn btn-danger float-right">Reset</a>
                                    </div>

                                </div>



                                <div class="form-row">

                                    <div class="form-row col-md-2">

                                        <div class="form-group col-md-12 pr-0">
                                            <select class="select2-box form-control" name="buyer_id" laravel-model="Buyer" laravel-get-from="name" laravel-belongs="agent">
                                                <option value="{{ $buyer_id }}">{{ $buyer_id ? ucwords(App\Buyer::find($buyer_id)->name):null }}</option>
                                            </select>
                                            <div class="filter-name">Buyer Name</div>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-2">
                                        <select class="select2-box-field-filter form-control" name="name" laravel-model="Order" laravel-get-from="name" laravel-direct-value="true">
                                            <option value="{{ $name }}">{{ $name }}</option>
                                        </select>
                                        <div class="filter-name">Order Name</div>
                                    </div>
                                    <div class="form-group col-md-2">
                                        <select class="select2-box-field-filter form-control" name="style" laravel-model="Order" laravel-get-from="style" laravel-direct-value="true">
                                            <option value="{{ $style }}">{{ ucwords($style) }}</option>
                                        </select>
                                        <div class="filter-name">Style Name</div>
                                    </div>

                                    <div class="form-group col-md-2">
                                        <select class="select2-box-field-filter form-control" name="style_desc" laravel-model="Order" laravel-get-from="style_desc" laravel-direct-value="true">
                                            <option value="{{ $style_desc }}">{{ ucwords($style_desc) }}</option>
                                        </select>
                                        <div class="filter-name">Style Desc</div>
                                    </div>

                                    @if(isset($ord_quantity) || Route::is('production-create'))
                                        <div class="form-group col-md-1">
                                            <select class="select2-box-field-filter form-control" name="ord_quantity" laravel-model="Order" laravel-get-from="ord_quantity" laravel-direct-value="true">
                                                <option value="{{ $ord_quantity }}">{{ $ord_quantity }}</option>
                                            </select>
                                            <div class="filter-name">Quantity</div>
                                        </div>
                                    @endif

                                    <div class="form-group col-md-1 pl-0">
                                        <select class="select2-box-manual form-control" name="statuses">
                                            <option value="{{ $statuses }}">{{ $statuses ?? 'Select...' }}</option>
                                            <option value="Running">Running</option>
                                            <option value="Partial">Partial</option>
                                            <option value="ShipOut">ShipOut</option>
                                        </select>
                                        <div class="filter-name">Order Status</div>
                                    </div>
                                    <div class="form-group col-md-1 pl-0">
                                        <select class="select2-box form-control" name="category_id" laravel-model="OrderCategory" laravel-get-from="name">
                                            <option value="{{ $category_id }}">{{ $category_id ? ucwords(App\OrderCategory::find($category_id)->name) : null }}</option>
                                        </select>
                                        <div class="filter-name">Category</div>
                                    </div>


                                    <div class="form-group col-md-1">
                                        <input type="hidden" name="order_filter_form" value="submit">
                                        <button type="submit" class="mb-2 btn btn-primary">Search</button>

                                    </div>
                                </div>
                            </form>




                            <!-- Transaction History Table -->
                            <table class="filter-data-table d-none text-capitalize" id="main-table">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th>ID</th>
                                    <th>Buyer</th>
                                    <th>OrderName</th>
                                    <th>Style</th>
                                    <th>StyleDesc</th>
                                    <th>Image</th>
                                    <th>Shipment</th>
                                    <th style="background: #ffd3b0;color: #000;">RemDay</th>
                                    <th>OrderQty</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($orders as $order)
                                    @php
                                        $pieChartMaterials[$order->buyer->name]['quantity'][] = $order->quantity->sum('quantity');
                                        $pieChartMaterials[$order->buyer->name]['value'][] = $order->quantity->sum('quantity')*$order->unit_price;

                                        $dateOfShip = $order->date_of_ship;
                                        $dateForHumans = Carbon::parse($dateOfShip)->diffForHumans(Carbon::now());
                                        $diff = -Carbon::parse($dateOfShip)->diffInDays(Carbon::now(), false)
                                    @endphp
                                    <tr>
                                        {{--Select--}}              <td> @if($id) <a class="btn btn-primary bg-primary text-dark" href="#">Selected</a> @else <a class="btn btn-primary bg-white text-dark" href="create?id={{ $order->id }}">Select</a> @endif </td>
                                        {{--Job ID--}}              <td>{{ $order->id }}</td>
                                        {{--Byuer--}}               <td>{{ $order->buyer->name }}</td>
                                        {{--order name--}}          <td>{{ $order->name }}</td>
                                        {{--style name--}}          <td>{{ $order->style }}</td>
                                        {{--style desc--}}          <td>{{ $order->style_desc }}</td>
                                        {{--getGarmentsPicture--}}  <td><img class="zoom" width="50" src="{{ $order->getGarmentsPicture() }}" alt=""></td>{{--Dalay--}}
                                        {{--Shipment Date--}}       <td>{{ $dateOfShip }}</td>
                                        {{--Rem Day--}}             <td> <div class="badge {{ ($diff<=10)?(($diff<0)?'badge-danger':'badge-warning'):'badge-info' }}">{{ $diff }}</div><br> {{ str_replace(['before', 'after'], ['delay', 'remain'], $dateForHumans) }}</td>
                                        {{--Order Qty--}}           <td>{{ $order->quantity->sum('quantity') }}</td>

                                    </tr>
                                @endforeach
                                </tbody>

                            </table>
                            <!-- End Transaction History Table -->



                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>
