@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title">{{ $pageData['pageName'] }} List</h3>
            </div>
{{--            <div class="float-right col-12 col-sm-8 text-center text-sm-right">--}}
{{--                <span class="text-uppercase page-subtitle">Action</span>--}}
{{--                <h3 class="page-title">--}}
{{--                    <a href="{{ route($pageData['routeFirstName'].'-create') }}" class="btn btn-md btn-white">--}}
{{--                        <i class="material-icons">person</i> Add--}}
{{--                    </a>--}}
{{--                </h3>--}}
{{--            </div>--}}
        </div>
        <!-- End Page Header -->
        <div class="row">
            <div class="col-lg-12 mb-1">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <form>
                                        <div class="form-row">
                                            <div class="form-group col-md-3">
                                                <select class="select2-box-field-filter form-control" name="name" laravel-model="{{ $pageData['pageName'] }}" laravel-get-from="name" laravel-direct-value="true">
                                                    <option value="{{ $name }}">{{ $name }}</option>
                                                </select>
                                                <div class="filter-name">{{ $pageData['pageName'] }} Name</div>
                                            </div>

                                            <div class="form-group col-md-3">
                                            </div>
                                            <div class="form-group col-md-2">
                                                <button type="submit" class="mb-2 btn btn-primary">Search</button>

                                                <a href="{{ route($pageData['routeFirstName'].'-list') }}" class="mb-2 btn btn-dark">Reset</a>
                                            </div>
                                            <div class="form-group col-md-1 p-0">
                                                <button @click="doit" type="button" class="float-right btn btn-info">
                                                    <i class="material-icons">save_alt</i> Export
                                                </button>
                                            </div>
                                            <div class="form-group col-md-1">
                                                <select name='per_page' class="form-control is-invalid" @change="per_page">
                                                    @foreach($per_page_rows as $number)
                                                        <option {{ ($per_page==$number) ? "selected" : null }}>{{ $number }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">Rows</div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12 mb-3">
                <div class="card card-small">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item p-2">
                            <div class="row">
                                <div class="col-md-2">
                                    <b>Total : </b> <span>{{ $count }} {{ $pageData['pageName'] }} Found</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Default Light Table -->
        <div class="row">
            <div class="col">
                <div class="card card-small mb-4">
                    <div class="card-header border-bottom">
                        {{--From Controller--}}
                        <h6 class="m-0">Active {{ $pageData['pageName'] }}s</h6>
                    </div>
                    <div class="card-body p-0 pb-3 text-center">
                        <table class="table mb-0" id="main-table" >
                            <thead class="bg-light">
                            <tr>
                                <th scope="col" class="border-0">Sl</th>
                                <th scope="col" class="border-0">Name</th>
                                <th scope="col" class="border-0">Set</th>
                                <th scope="col" class="border-0">Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php
                                $companyName = $mainDatas->where('name', 'companyName')->first();
                                $ShipmentScheduleChartStartMonth = $mainDatas->where('name', 'shipmentScheduleChartStartMonth')->first();
                                $ShipmentScheduleChartStartYear = $mainDatas->where('name', 'shipmentScheduleChartStartYear')->first();
                                $erpBackgroundColor = $mainDatas->where('name', 'erpBackgroundColor')->first();
                                $defaultYear = $mainDatas->where('name', 'Default Year')->first();
                                $ownNetworkIP = $mainDatas->where('name', 'Own Network IP')->first();
                                $debug = $mainDatas->where('name', 'Debug')->first();

                                $sprint = 0;
                            @endphp

                            @if($companyName)
                            <tr>
                            {{--1--}}
                                <td>{{ ++$sprint }}</td>
                                <td>{{ $companyName->name }}</td>
                                <td>{{ $companyName->value }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">

                                        <a href="{{ route($pageData['routeFirstName'].'-edit', $companyName->id) }}" class="btn btn-white">
                                            <i class="material-icons"></i>
                                        </a>

                                    </div>
                                </td>
                            </tr>
                            @endif


                            @if($ShipmentScheduleChartStartYear)
                            <tr>
                                {{--3--}}
                                <td>{{ ++$sprint }}</td>
                                <td>{{ $ShipmentScheduleChartStartYear->name }}</td>
                                <td>
                                    @switch($ShipmentScheduleChartStartYear->value)

                                        @case(-1)
                                        <button class="btn btn-dark">Previous Year - {{ date('Y') + $ShipmentScheduleChartStartYear->value }}</button>
                                        @break
                                        @case(0)
                                        <button class="btn btn-dark">Present Year - {{ date('Y') + $ShipmentScheduleChartStartYear->value }}</button>
                                        @break
                                        @case(1)
                                        <button class="btn btn-dark">Next Year - {{ date('Y') + $ShipmentScheduleChartStartYear->value }}</button>
                                        @break


                                    @endswitch
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">

                                        <a href="{{ route($pageData['routeFirstName'].'-edit', $ShipmentScheduleChartStartYear->id) }}" class="btn btn-white">
                                            <i class="material-icons"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endif


                            <tr>
                            {{--2--}}
                                <td>{{ ++$sprint }}</td>
                                <td>{{ $ShipmentScheduleChartStartMonth->name }}</td>
                                <td>
                                    <button class="btn btn-dark">{{ $ShipmentScheduleChartStartMonth->value }}</button>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">

                                        <a href="{{ route($pageData['routeFirstName'].'-edit', $ShipmentScheduleChartStartMonth->id) }}" class="btn btn-white">
                                            <i class="material-icons"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>


                            <tr>
                            {{--4--}}
                                <td>{{ ++$sprint }}</td>
                                <td>{{ $erpBackgroundColor->name }}</td>
                                <td>
                                    <button class="btn btn-dark" style="background: {{ $erpBackgroundColor->value }}; text-shadow: 1px 1px 2px #000000">{{ $erpBackgroundColor->value }}</button>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">

                                        <a href="{{ route($pageData['routeFirstName'].'-edit', $erpBackgroundColor->id) }}" class="btn btn-white">
                                            <i class="material-icons"></i>
                                        </a>

                                    </div>
                                </td>
                            </tr>

                            <tr>
                            {{--5--}}
                                <td>{{ ++$sprint }}</td>
                                <td>{{ $defaultYear->name }}</td>
                                <td>{{ $defaultYear->value }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">

                                        <a href="{{ route($pageData['routeFirstName'].'-edit', $defaultYear->id) }}" class="btn btn-white">
                                            <i class="material-icons"></i>
                                        </a>

                                    </div>
                                </td>
                            </tr>

                            <tr>
                            {{--6--}}
                                <td>{{ ++$sprint }}</td>
                                <td>{{ $ownNetworkIP->name }}</td>
                                <td>
                                    @foreach(explode('|', $ownNetworkIP->value) as $ip)
                                        <span class="border border-danger rounded bg-salmon">http://{{ $ip }}</span>
                                    @endforeach
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">

                                        <a href="{{ route($pageData['routeFirstName'].'-edit', $ownNetworkIP->id) }}" class="btn btn-white">
                                            <i class="material-icons"></i>
                                        </a>

                                    </div>
                                </td>
                            </tr>

                            <tr>
                            {{--7--}}
                                <td>{{ ++$sprint }}</td>
                                <td>{{ $debug->name }}</td>
                                <td>{{ $debug->value === 'true' ? 'True': 'False' }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group" aria-label="Table row actions">

                                        <a href="{{ route($pageData['routeFirstName'].'-edit', $debug->id) }}" class="btn btn-white">
                                            <i class="material-icons"></i>
                                        </a>

                                    </div>
                                </td>
                            </tr>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Default Dark Table -->
    </div>
@endsection

@section('vue-script')
    @include('js/script')
@endsection
