<?php

namespace App\Http\Controllers;

use App\Accessories;
use App\Budget, Auth;
use App\Commercial;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CommercialController extends Controller
{
    public $_profile_pic_folder = 'profile-pic/garments';
    public $pageData = [];
    public $pageName = 'Commercial';
    public $viewFolder = 'commercial';

    public function __construct()
    {
        $pageName = 'commercial';
        $this->pageData = [
            'no' => 0,
            'pageName' => Str::studly($pageName),
            'routeFirstName' => $pageName,
            'ignoreColsInExport' => '[0]',
        ];

        view()->share('pageData', $this->pageData);

    }

    public function filterCommercial($query, $request)
    {

        $query = $query->where('data_status', 'running');

        //dd($payloads);

        //dd($request->all());
        //$query = Commercial::query();
        //$query = $query->with(['budget:order_id,cm,yarn_consumption', 'buyer', 'quantity', 'status', 'shipment']);
        $id = $request->get('id') ?? null;
        $name = $request->get('name') ?? null;
        $accessories_id = $request->get('accessories_id') ?? null;
        $party_id = $request->get('party_id') ?? null;
        $lc = $request->get('lc') ?? null;
        $lc_number = $request->get('lc_number') ?? null;
        $lc_purpose = $request->get('lc_purpose') ?? null;
        $bank_acceptance_amount = $request->get('bank_acceptance_amount') ?? null;
        $payment_status = $request->get('payment_status') ?? null;
        $lc_value = $request->get('lc_value') ?? null;
        $tenor = $request->get('tenor') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;
        $filterYear = $request->get('filterYear') ?? null;

        //$date_type = $request->get('date_type') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
        }
        if($request->filled('party_id')) {
            $query = $query->where('party_id', $request->get('party_id') );
        }
        if($request->filled('accessories_id')) {
            $query = $query->where('accessories_id', $request->get('accessories_id') );
        }
        if($request->filled('lc_number')) {
            $query = $query->where('lc_number', $request->get('lc_number') );
        }
        if($request->filled('bank_acceptance_amount')) {

            if($request->get('bank_acceptance_amount') == 'NonFunded') {

                $query = $query->whereNull('bank_acceptance_amount');

            } else if ($request->get('bank_acceptance_amount') == 'Funded') {

                $query = $query->whereNotNull('bank_acceptance_amount' );

            }

            //$query = $query->where('bank_acceptance_amount', $request->get('bank_acceptance_amount') );
        }
        if($request->filled('payment_status')) {
            $query = $query->where('payment_status', $request->get('payment_status') );
        }
        if($request->filled('lc_purpose')) {
            $query = $query->where('lc_purpose', $request->get('lc_purpose') );
        }

        if($request->filled('from') && $request->filled('to')) {

            /*if ($request->get('date_type') == 'actual_shipDate') {
                $query = $query->where('statuses', 'ShipOut')
                    ->whereBetween('updated_at', [$request->get('from'), $request->get('to')] )
                ;
            } else {
                $query = $query->whereBetween($request->get('date_type'), [$request->get('from'), $request->get('to')] );
            }*/

            if ($request->filled('date_type')) {
                $query = $query->whereBetween($request->get('date_type'), [$request->get('from'), $request->get('to')] );
            } else {
                $query = $query->whereBetween('lc_date', [$request->get('from'), $request->get('to')] );
            }

            //dd($request->get('date_type'));
        }

        //$today = date('Y-m-d');

        if(!$request->filled('data_filtering')) {

            $query = $query->limit(20);

        }

        $commercials = $query->orderBy('id', 'desc')->get();

        /*if($request->filled('today_order_entry')) {
            $from = $today;
            $to = $today;
            $request['date_type'] = 'order_accept_date';
            $query = $query->where('order_accept_date', $today);
        }*/


        //$orders = $query->orderBy('date_of_ship')->get();
        //dd($orders);
        //$orders->setpath($request->fullUrl()."&per_page=$per_page");

        $compact = compact(
            'id',
            'accessories_id',
            'party_id',
            'name',
            'lc',
            'lc_number',
            'payment_status',
            'lc_purpose',
            'lc_value',
            'bank_acceptance_amount',
            'tenor',
            'from',
            'to',
            'filterYear',
            'per_page',
            'commercials'
        );

        //dd($orders);

        return $compact;
    }
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function commercialExpenseFieldPaymentDueValues()
    {
        $accessoriesFields = [
            'Forced Loan',
            'EDF Loan',
            'FDBP',
            'Packing Credit (PC)'
        ];

        $commercialExpenseFieldPaymentDueValues = [];

        foreach ($accessoriesFields as $field) {
            $fieldModel = Accessories::where('name', $field)->first();

            $field_id = $fieldModel->id ?? 0;

            $sum = Commercial::where([['accessories_id', $field_id], ['payment_status', 'PaymentDue']])->sum('lc_value');

            $commercialExpenseFieldPaymentDueValues[$field] = $sum;
        }

        $allCommercialPaymentDue = Commercial::where('payment_status', 'PaymentDue')->sum('lc_value');

        return compact('allCommercialPaymentDue', 'commercialExpenseFieldPaymentDueValues');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $query = Commercial::query();

        $compact = $this->filterCommercial($query, $request);

        $paymentDueValuesCompact = $this->commercialExpenseFieldPaymentDueValues();

        $commercialsModel = new Commercial();

        if (request()->has('filterYearChart')) {
            $monthWiseCommercial = $commercialsModel->monthWiseCommercial($request->get('filterYearChart'), "Jan");
        } else {
            $monthWiseCommercial = $commercialsModel->monthWiseCommercial(date('Y'), "Jan");
        }

        /*if (request()->has('filterYearChart')) {
            $orderYearWiseMonth = $commercialsModel->monthWiseCommercial(request()->get('filterYearChart'), $startMonth);
        } else {
            $orderYearWiseMonth = $commercialsModel->monthWiseCommercial(date('Y') + $selectedYear, $startMonth);
        }*/

        if($request->filled('excel')) {
            return $this->export($compact);
        }

        $compact += $paymentDueValuesCompact;

        $compact += compact(
            'monthWiseCommercial'
        );

        //dd($monthWiseCommercial['lc']);

        return view('commercial.index', $compact)
            ->withCount($compact['commercials']->count())
            ;
    }

    public function dueIndex(Request $request)
    {
        //PaymentDue

        $query = Commercial::query();
        $payloads = [];

        $query = $query->where([
            ['maturity_date', '<=', date('Y-m-d')],
            [function($query){
                $query
                    ->where('payment_status', 'PaymentDue')
                    ->orWhere('payment_status', 'PartialPaid');
            }]
        ]);

        $payloads['allPaymentDues'] = $query
            ->get()
            ->groupBy(function ($qr){
            return Carbon::parse($qr->maturity_date)->format('Y-m');
        });

        $compact = $this->filterCommercial($query, $request);

        $compact += compact(
            'payloads'
        );

        //dd($monthWiseCommercial['lc']);

        return view('commercial.dueIndex', $compact)
            ->withCount($compact['commercials']->count())
            ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $checkEditedValueMatch = function(){
            return false;
        };

        return view('commercial.create')
            ->withCheckEditedValueMatch($checkEditedValueMatch)
            //->withPrevBudget($prevBudgetForShow)
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Commercial $commercial = null)
    {
        //dd($commercial);
        ini_set('max_execution_time', 1600);
        //dd($request['order_qty'][0]['qty']);
        //dd($request->all());
        /*echo '<pre>';
        print_r($request->all());
        echo '</pre>';*/
        //dd($request->all());
        $loggedUser = Auth::user();
        /*if(!$loggedUser->can_manage_user())
        {
            //return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        $team_ids = $loggedUser->role->managed_user_team_ids();*/
        //dd($team_ids);

        //$request['accessories_id'] = 8;
        //$request['party_id'] = 2;

        $request->validate([
            //'item_name' => 'required|max:255',
            'accessories_id' => 'required|exists:accessories,id',
            'party_id' => 'required|exists:parties,id',
            //'pi_number' => 'required',
            //'lc_number' => 'required',

            //'lc_date' => 'required',
            //'maturity_date' => 'required|integer',
            //'payment_date' => 'required|integer',

            //'bank_acceptance_date' => 'nullable|required_with:bank_acceptance_amount',
            //'bank_acceptance_amount' => 'nullable|numeric|required_with:bank_acceptance_date',
            'lc_value' => 'required|numeric',
            'tenor' => 'required|integer',
            //'lc_purpose' => 'required|integer',

            // payment_status
            //'payment_amount' => 'numeric'
            //'bank_acceptance_amount' => 'numeric',
            // payment_status
            //'payment_amount' => 'numeric'
            //'description' => 'required|integer',
        ]);
        /*if(!in_array($loggedUser->team->id,$team_ids))
        {
            //return redirect()->back()->with(['fail'=>'Permission denied to assign user to this team.']);
        }*/

        $model = new Commercial();

        if ($commercial) {
            $model = $commercial;
        }

        $model->user_id = $loggedUser->id;
        $model->accessories_id = $request['accessories_id'];
        //$model->item_name = $request['item_name'];
        $model->party_id = $request['party_id'];

        $model->pi_number = $request['pi_number'];
        $model->lc_number = $request['lc_number'];
        $model->lc_value = $request['lc_value'];
        $model->tenor = $request['tenor'];

        $model->bank_acceptance_amount = $request['bank_acceptance_amount'];
        $model->payment_amount = $request['payment_amount'];
        //$model->payment_status = 'PaymentDue';
        $model->lc_date = date('Y-m-d');
        $model->bank_acceptance_date = null;
        $model->payment_date = null;

        if($request->filled('lc_purpose')) {
            $model->lc_purpose = $request['lc_purpose'];
        }

        if($request->filled('payment_status')) {
            $model->payment_status = $request['payment_status'];
        }

        if($request->filled('lc_date')) {
            $model->lc_date = $request['lc_date'];
        }
        if($request->filled('bank_acceptance_date')) {
            $model->bank_acceptance_date = $request['bank_acceptance_date'];

            $model->maturity_date
                = Carbon::parse($request['bank_acceptance_date'])
                ->addDays($request['tenor'])
                ->format('Y-m-d');
        }
        if($request->filled('payment_date')) {
            $model->payment_date = $request['payment_date'];
        }


        /*if($request->filled('order_accept_date')) {
            //$model->order_accept_date = $request['order_accept_date'];
        }

        if ($request->has('reporting_to_user_id')) {
            $model->reporting_to_user_id = $request['reporting_to_user_id'];
        }*/

        $model->description = $request['description'];

        $model->save();

        return redirect()->route($this->pageData['routeFirstName'].'-list', 'id='.$model->id)->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Commercial  $commercial
     * @return \Illuminate\Http\Response
     */
    public function show(Commercial $commercial)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Commercial  $commercial
     * @return \Illuminate\Http\Response
     */
    public function edit(Commercial $commercial)
    {
        return $this->create()
            ->withIsSetModel($commercial)
            ;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Commercial  $commercial
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Commercial $commercial)
    {
        //dd($request->all());
        $this->store($request, $commercial);

        return redirect()
            ->route($this->pageData['routeFirstName'].'-list', 'id='.$commercial->id)
            ->with(['success'=>$this->pageData['pageName'].' Updated Successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Commercial  $commercial
     * @return \Illuminate\Http\Response
     */
    public function destroy(Commercial $commercial)
    {
        //
    }
}
