<?php

namespace App\Http\Controllers;

use App\CommercialInvoice;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CommercialInvoiceController extends Controller
{
    public $_profile_pic_folder = 'profile-pic/garments';
    public $pageData = [];

    public function __construct()
    {
        $this->pageData = [
            'no' => 0,
            'pageName' => 'Commercial Invoice',
            'routeFirstName' => 'commercial-invoice',
            'ignoreColsInExport' => '[0]',
        ];

        view()->share('pageData', $this->pageData);

    }

    public function filterCommercialInvoice($query, $request)
    {

        $query = $query->where('data_status', 'running');

        //dd($payloads);

        //dd($request->all());
        //$query = Commercial::query();
        //$query = $query->with(['budget:order_id,cm,yarn_consumption', 'buyer', 'quantity', 'status', 'shipment']);

        $filterArray = [
            'id' => $request->get('id') ?? null,
            'buyer_id' => $request->get('buyer_id') ?? null,
            'invoice_number' => $request->get('invoice_number') ?? null,
            'payment_receive_status' => $request->get('payment_receive_status') ?? null,
            'from' => $request->get('from') ?? null,
            'to' => $request->get('to') ?? null,
            'filterYear' => $request->get('filterYear') ?? null
        ];

        /*$name = $request->get('name') ?? null;
        $accessories_id = $request->get('accessories_id') ?? null;
        $lc = $request->get('lc') ?? null;
        $lc_purpose = $request->get('lc_purpose') ?? null;
        $bank_acceptance_amount = $request->get('bank_acceptance_amount') ?? null;
        $lc_value = $request->get('lc_value') ?? null;
        $tenor = $request->get('tenor') ?? null;*/

        //$date_type = $request->get('date_type') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
        }
        if($request->filled('invoice_number')) {
            $query = $query->where('invoice_number', $request->get('invoice_number') );
        }

        if($request->filled('payment_receive_status')) {
            $query = $query->where('payment_receive_status', $request->get('payment_receive_status') );
        }


        if($request->filled('from') && $request->filled('to')) {
            if ($request->filled('date_type')) {
                $query = $query->whereBetween($request->get('date_type'), [$request->get('from'), $request->get('to')] );
            } else {
                $query = $query->whereBetween('invoice_date', [$request->get('from'), $request->get('to')] );
            }
        }


        if(!$request->filled('data_filtering')) {

            $query = $query->limit(20);

        }

        $commercial_invoices = $query->orderBy('id', 'desc')->get();

        /*if($request->filled('today_order_entry')) {
            $from = $today;
            $to = $today;
            $request['date_type'] = 'order_accept_date';
            $query = $query->where('order_accept_date', $today);
        }*/


        //$orders = $query->orderBy('date_of_ship')->get();
        //dd($orders);
        //$orders->setpath($request->fullUrl()."&per_page=$per_page");

        $compact = compact(
            'filterArray',
            'per_page',
            'commercial_invoices'
        );

        //dd($orders);

        return $compact;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $query = CommercialInvoice::query();

        $compact = $this->filterCommercialInvoice($query, $request);


        if($request->filled('excel')) {
            return $this->export($compact);
        }

        /*$compact += compact(
            'monthWiseCommercial'
        );*/

        return view('commercial_Invoice.index', $compact)
            ->withCount($compact['commercial_invoices']->count())
            ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $checkEditedValueMatch = function(){
            return false;
        };

        return view('commercial_Invoice.create')
            ->withCheckEditedValueMatch($checkEditedValueMatch)
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, CommercialInvoice $commercialInvoice = null)
    {
        //dd($request->all());

        ini_set('max_execution_time', 1600);

        $loggedUser = Auth::user();

        $request->validate([
            'buyer_id' => 'required|exists:buyers,id',
            'invoice_number' => 'required|max:255',
            'invoice_date' => 'required',
            'invoice_value' => 'required|numeric',
            'payment_mode' => 'required|integer',
            'master_lc_no_OR_sc_no' => 'required|max:255',
            'ex_factory_date' => 'required',
            //'bl_date' => 'required',

            'payment_receive_date' => 'nullable',
            'payment_receive_amount' => 'nullable|numeric',
            'document_purchase_date' => 'nullable',
            'document_purchase_amount' => 'nullable|numeric',
        ]);

        $model = new CommercialInvoice();

        if ($commercialInvoice) {
            $model = $commercialInvoice;
        }

        $model->user_id =                   $loggedUser->id;
        $model->buyer_id =                  $request['buyer_id'];
        $model->invoice_number =            $request['invoice_number'];
        $model->invoice_date =              $request['invoice_date'];
        $model->invoice_value =             $request['invoice_value'];
        $model->payment_mode =              $request['payment_mode'];
        $model->master_lc_no_OR_sc_no =     $request['master_lc_no_OR_sc_no'];
        $model->ex_factory_date =           $request['ex_factory_date'];
        $model->bl_date =                   $request['bl_date'];
        $model->payment_receive_date =      $request['payment_receive_date'];
        $model->payment_receive_amount =    $request['payment_receive_amount'];
        $model->payment_receive_status =    $request['payment_receive_status'];
        $model->document_purchase_date =    $request['document_purchase_date'];
        $model->document_purchase_amount =  $request['document_purchase_amount'];
        $model->description =               $request['description'];

        $model->save();

        return redirect()->route($this->pageData['routeFirstName'].'-list', 'id='.$model->id)->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CommercialInvoice  $commercialInvoice
     * @return \Illuminate\Http\Response
     */
    public function show(CommercialInvoice $commercialInvoice)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CommercialInvoice  $commercialInvoice
     * @return \Illuminate\Http\Response
     */
    public function edit(CommercialInvoice $commercialInvoice)
    {
        return $this->create()
            ->withIsSetModel($commercialInvoice)
            ;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CommercialInvoice  $commercialInvoice
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CommercialInvoice $commercialInvoice)
    {
        $this->store($request, $commercialInvoice);

        return redirect()
            ->route($this->pageData['routeFirstName'].'-list', 'id='.$commercialInvoice->id)
            ->with(['success'=>$this->pageData['pageName'].' Updated Successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CommercialInvoice  $commercialInvoice
     * @return \Illuminate\Http\Response
     */
    public function destroy(CommercialInvoice $commercialInvoice)
    {
        //
    }
}
