<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use App\Order, Auth;
use App\Production;
use Illuminate\Http\Request;

class ProductionController extends Controller
{
    public $_profile_pic_folder = 'profile-pic/garments';
    public $pageData = [];

    public function __construct()
    {
        $pageName = 'production';
        $this->pageData = [
            'no' => 0,
            'pageName' => Str::studly($pageName),
            'routeFirstName' => $pageName,
            'ignoreColsInExport' => '[0]',
        ];

        view()->share('pageData', $this->pageData);

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $query = Order::query()->where('history_type', 'Running');
        $query = $query->with(
            [
                'budget:order_id,cm',
                'buyer',
                'status',
                'shipment',
                'quantity',
                'cutting',
                'swingIn',
                'swingOut',
                'iron',
                'packing'
            ]
        );
        $id = $request->get('id') ?? null;
        $buyer_id = $request->get('buyer_id') ?? null;
        $name = $request->get('name') ?? null;
        $ord_quantity = $request->get('ord_quantity') ?? null;
        $style = $request->get('style') ?? null;
        $style_desc = $request->get('style_desc') ?? null;
        $statuses = $request->get('statuses') ?? null;
        $category_id = $request->get('category_id') ?? null;
        $sub_category_id = $request->get('sub_category_id') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('name')) {
            $query = $query->where('name', $request->get('name') );
            //$phone = $request->get('phone');
        }
        if($request->filled('ord_quantity')) {
            $query = $query->where('ord_quantity', $request->get('ord_quantity') );
        }
        if($request->filled('style')) {
            $query = $query->where('style', $request->get('style') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style_desc')) {
            $query = $query->where('style_desc', $request->get('style_desc') );
            //$phone = $request->get('phone');
        }
        if($request->filled('statuses')) {
            $query = $query->where('statuses', $request->get('statuses') );
            //$phone = $request->get('phone');
        }
        if($request->filled('sub_category_id')) {
            $query = $query->where('sub_category_id', $request->get('sub_category_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('from') && $request->filled('to')) {
            $query = $query->whereBetween('date_of_ship', [$request->get('from'), $request->get('to')] );
            //$phone = $request->get('phone');
        }

        /*last 10 days*/
        if(!$request->has('data_filtering')) {
            $today = date('Y-m-d');
            $hasDays = date('Y-m-d', strtotime('10 days', strtotime($today)));

            $query = $query->whereBetween('date_of_ship', [$today, $hasDays]);
        }
        /*end last 10 days*/

        $orders = $query->orderBy('date_of_ship')->get();

        $compact = compact(
            'id',
            'buyer_id',
            'name',
            'ord_quantity',
            'style',
            'style_desc',
            'statuses',
            'category_id',
            'sub_category_id',
            'from',
            'to',
            'per_page',
            'orders'
        );

        return view('productions.index', $compact)
            ->withCount($query->get()->count())
            ;
    }

    public function dateWiseList(Request $request)
    {
        //dd(Production::find(1)->cutting());
        $query = Order::query()->where('history_type', 'Running');
        $productionQuery = Production::query();

        $query = $query->with(['budget:order_id,cm', 'buyer', 'status', 'shipment']);
        $id = $request->get('id') ?? null;
        $buyer_id = $request->get('buyer_id') ?? null;
        $name = $request->get('name') ?? null;
        $style = $request->get('style') ?? null;
        $style_desc = $request->get('style_desc') ?? null;
        $statuses = $request->get('statuses') ?? null;
        $category_id = $request->get('category_id') ?? null;
        $sub_category_id = $request->get('sub_category_id') ?? null;
        $from = $request->get('from') ?? null;
        $to = $request->get('to') ?? null;

        $per_page=(int)$request->input('per_page');

        if($per_page<=0)
        {
            $per_page = 20;
        }

        if($request->filled('id')) {
            $query = $query->where('id', $request->get('id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('buyer_id')) {
            $query = $query->where('buyer_id', $request->get('buyer_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('name')) {
            $query = $query->where('name', $request->get('name') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style')) {
            $query = $query->where('style', $request->get('style') );
            //$phone = $request->get('phone');
        }
        if($request->filled('style_desc')) {
            $query = $query->where('style_desc', $request->get('style_desc') );
            //$phone = $request->get('phone');
        }
        if($request->filled('statuses')) {
            $query = $query->where('statuses', $request->get('statuses') );
            //$phone = $request->get('phone');
        }
        if($request->filled('sub_category_id')) {
            $query = $query->where('sub_category_id', $request->get('sub_category_id') );
            //$phone = $request->get('phone');
        }
        if($request->filled('from') && $request->filled('to')) {
            $productionQuery = $productionQuery->whereBetween('date', [$request->get('from'), $request->get('to')] );
            //$phone = $request->get('phone');
        }

        /*last 10 days*/
        if(!$request->has('data_filtering')) {
            $today = date('Y-m-d');
            $hasDays = date('Y-m-d', strtotime('10 days', strtotime($today)));

            $query = $query->whereBetween('date_of_ship', [$today, $hasDays]);
        }
        /*end last 10 days*/

        $orders = $query->orderBy('date_of_ship')->get();

        $order_ids = [];

        foreach ($query->get() as $ord) {
            $order_ids[] = $ord->id;
        }

        //dd($order_ids);

        //$productions = Production::runningProductions()->get();
        //$productions = Production::where('history_type', 'Running')->get();
        $unique_productions = $productionQuery->whereIn('order_id', $order_ids)->where('history_type', 'Running')->distinct()->get(['id', 'order_id', 'date', 'line_id', 'quantity', 'production_type']);
        //$productions = Production::where('history_type', 'Running')->groupBy('order_id')->get();

        /*foreach ($unique_productions as $ff) {
            dump($ff->line->number ?? '');
        }
        dd('');*/



        /*$production_array = [];
        foreach ($productions as $production) {
            if ($production->id) {
            }
            $production_array[] = [
                'model' => $production,
            ];
        }*/

        //dd($productions);

        $compact = compact(
            'id',
            'buyer_id',
            'name',
            'style',
            'style_desc',
            'statuses',
            'category_id',
            'sub_category_id',
            'from',
            'to',
            'per_page'
        );

        if (count($unique_productions) > 0 ) {
            $compact += compact(
                'unique_productions'
            );
        }



        return view('productions.date_wise.index', $compact)
            ->withCount($query->get()->count())
            ;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        //dd($request->filled('bulk'));
        //$bulkInput = $request->get('bulk') ?? null;

        $id = $request->get('id') ?? null;

        if ($request->filled('bulk')) {
            Cache::forever('bulkInput', $request->get('bulk'));
        }

        $bulkInputFromCache = Cache::get('bulkInput');

        $compact = compact(
            'id'
        );

        $filterOrder = (new UtilityController)->filterOrder($request);
        $compact += $filterOrder;


        if ($bulkInputFromCache == 'yes') {
            $createPage = 'create-bulk';
        } else {
            $createPage = 'create';
        }

        return view('productions.'.$createPage, $compact)
            ->withOrder(Order::find($id))
            ;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, Order $order)
    {
        //dd($order);
        //dd($request->all());

        if (!$order) {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        $loggedUser = Auth::user();
        if(!$loggedUser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        $team_ids = $loggedUser->role->managed_user_team_ids();

        if(!in_array($loggedUser->team->id,$team_ids))
        {
            return redirect()->back()->with(['fail'=>'Permission denied to assign user to this team.']);
        }

        //dd($team_ids);
        $request->validate([
            'production_type' => 'required',
            'quantity' => 'required|numeric',
            'line_id' => Rule::requiredIf($request['production_type'] == 'swing_in' || $request['production_type'] == 'swing_out'),
            'sub_contract_id' => Rule::requiredIf($request['operation'] == 'SubContract'),
            'date' => 'nullable|date',
        ]);

        //dd($request->all());



        $productionDatas = Production::where('order_qty_id', $request['order_quantity_id'])->get();
        //dd($productionDatas);
        $cuttingSum = $productionDatas->where('production_type', 'cutting')->sum('quantity');
        $swing_inSum = $productionDatas->where('production_type', 'swing_in')->sum('quantity');
        $swing_outSum = $productionDatas->where('production_type', 'swing_out')->sum('quantity');
        $ironSum = $productionDatas->where('production_type', 'iron')->sum('quantity');
        $packingSum = $productionDatas->where('production_type', 'packing')->sum('quantity');

        switch ($request['production_type']) {
            case 'cutting':
                $cuttingSum = $cuttingSum + $request['quantity'];
                break;
            case 'swing_in':
                $swing_inSum = $swing_inSum + $request['quantity'];
                break;
            case 'swing_out':
                $swing_outSum = $swing_outSum + $request['quantity'];
                break;
            case 'iron':
                $ironSum = $ironSum + $request['quantity'];
                break;
            case 'packing':
                $packingSum = $packingSum + $request['quantity'];
                break;
        }


        $canProductionEntry = false;

        if (($cuttingSum >= $swing_inSum) && ($swing_inSum >= $swing_outSum) && ($swing_outSum >= $ironSum) && ($ironSum >= $packingSum)) {

            $canProductionEntry = true;
            //dd('ok', '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);

        }

        if (!$canProductionEntry) {
            //dd( 'if', $canProductionEntry, '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);
            return back()->withInput()->with(['fail'=>$this->pageData['pageName'].' quantity mismatch !']);
        }


        $model = new Production();
        $model->order_id = $order->id;
        $model->user_id = $loggedUser->id;
        $model->production_type = $request['production_type'];
        $model->order_qty_id = $request['order_quantity_id'];
        $model->quantity = $request['quantity'];
        $model->operation = $request['operation'];
        $model->date = date('Y-m-d');

        if ($request->filled('line_id')) {
            $model->line_id = $request['line_id'];
        }
        if ($request->filled('date')) {
            $model->date = $request['date'];
        }
        if ($request->filled('sub_contract_id')) {
            $model->sub_contract_id = $request['sub_contract_id'];
        }

        $model->save();
        return back()->withInput()->with(['success'=>$this->pageData['pageName'].' Created Successfully.']);
    }

    public function bulkStore(Request $request, Order $order)
    {
        //dd($order);
        //dd($request->all()['cutting']);

        if (!($request['cutting'] || $request['swing_in']['quantity'] || $request['swing_out']['quantity'] || $request['iron'] || $request['packing'])) {
            return back()->withInput()->with(['fail'=>$this->pageData['pageName'].' blank input !']);
        }

        $loggedUser = Auth::user();

        if (!$order) {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }

        $team_ids = $loggedUser->role->managed_user_team_ids();

        if(!in_array($loggedUser->team->id,$team_ids))
        {
            return redirect()->back()->with(['fail'=>'Permission denied to assign user to this team.']);
        }

        if(!$loggedUser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }


        $request->validate([
            'swing_in.line_id' => Rule::requiredIf($request['swing_in']['quantity'] != null),
            'swing_out.line_id' => Rule::requiredIf($request['swing_out']['quantity'] != null),

            'cutting' => 'nullable|integer',
            'iron' => 'nullable|integer',
            'packing' => 'nullable|integer',

            'sub_contract_id' => Rule::requiredIf($request['operation'] == 'SubContract'),
        ]);

        //dd($request['swing_in']['line_id']);

        $productionTypes = ['cutting', 'swing_in', 'swing_out', 'iron', 'packing'];

        $productionTypesString = '';

        foreach ($productionTypes as $productionType) {

            $productionDatas = Production::where('order_qty_id', $request['order_quantity_id'])->get();
            //dd($productionDatas);
            $cuttingSum = $productionDatas->where('production_type', 'cutting')->sum('quantity');
            $swing_inSum = $productionDatas->where('production_type', 'swing_in')->sum('quantity');
            $swing_outSum = $productionDatas->where('production_type', 'swing_out')->sum('quantity');
            $ironSum = $productionDatas->where('production_type', 'iron')->sum('quantity');
            $packingSum = $productionDatas->where('production_type', 'packing')->sum('quantity');

            //dd('ok', '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);

            $cuttingSum = $cuttingSum + $request['cutting'];
            $swing_inSum = $swing_inSum + $request['swing_in']['quantity'];
            $swing_outSum = $swing_outSum + $request['swing_out']['quantity'];
            $ironSum = $ironSum + $request['iron'];
            $packingSum = $packingSum + $request['packing'];

            $canProductionEntry = false;

            if (($cuttingSum >= $swing_inSum) && ($swing_inSum >= $swing_outSum) && ($swing_outSum >= $ironSum) && ($ironSum >= $packingSum)) {
                $canProductionEntry = true;
                //dd('ok', '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);
            }

            if (!$canProductionEntry) {
                //dd( 'if', $canProductionEntry, '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);
                return back()->withInput()->with(['fail'=>$this->pageData['pageName'].' quantity mismatch !']);
            }

            $model = new Production();
            $model->order_id = $order->id;
            $model->user_id = $loggedUser->id;
            $model->order_qty_id = $request['order_quantity_id'];

            if ($productionType == 'swing_in' || $productionType == 'swing_out' ) {
                $model->production_type = $productionType;
                $model->quantity = $request[$productionType]['quantity'];
                $model->line_id = $request[$productionType]['line_id'];
            } else {
                $model->production_type = $productionType;
                $model->quantity = $request[$productionType];
            }

            $model->operation = 'InHouse';
            $model->date = date('Y-m-d');

            if ($request->filled('line_id')) {
                $model->line_id = $request['line_id'];
            }
            if ($request->filled('operation')) {
                $model->operation = $request['operation'];
            }
            if ($request->filled('date')) {
                $model->date = $request['date'];
            }
            if ($request->filled('sub_contract_id')) {
                $model->sub_contract_id = $request['sub_contract_id'];
            }

            if ($model->quantity) {
                $productionTypesString .= $productionType. ', ';
                $model->save();
            }
        }
        $productionTypesString = ' ['.rtrim($productionTypesString, ', ').']';

        return back()->withInput()->with(['success'=>$this->pageData['pageName'].$productionTypesString.' Created Successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Production  $production
     * @return \Illuminate\Http\Response
     */
    public function show($order_id)
    {
        return view('layouts.orderDetails.show')
            ->withOrder(Order::find($order_id))
            ;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Production  $production
     * @return \Illuminate\Http\Response
     */
    public function edit(Production $production)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Production  $production
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Production $production)
    {
        //dd($request->all());
        $request->validate([
            //'type' => 'required',
            'qty' => 'required|numeric',
            //'line_id' => Rule::requiredIf($request['production_type'] == 'swing_in' || $request['production_type'] == 'swing_out'),
            //'sub_contract_id' => Rule::requiredIf($request['operation'] == 'SubContract'),
            //'date' => 'nullable|date',
        ]);




        if (!$production->order) {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        $loggedUser = Auth::user();
        //dd($loggedUser);
        /*if(!$loggedUser->can_manage_user())
        {
            return redirect()->back()->with(['fail'=>'Unauthorized Access.']);
        }
        $team_ids = $loggedUser->role->managed_user_team_ids();

        if(!in_array($loggedUser->team->id,$team_ids))
        {
            return redirect()->back()->with(['fail'=>'Permission denied to assign user to this team.']);
        }*/



        /*$productionDatas = Production::where('order_qty_id', $production['order_qty_id'])
            ->where('id', '!=', $production->id)
            ->get();*/

        $productionDatas = Production::where(
            [
               ['order_qty_id', $production['order_qty_id']],
               ['id', '!=', $production->id]
            ]
        )->get();

        //dd($productionDatas);

        $cuttingSum = $productionDatas->where('production_type', 'cutting')->sum('quantity');
        $swing_inSum = $productionDatas->where('production_type', 'swing_in')->sum('quantity');
        $swing_outSum = $productionDatas->where('production_type', 'swing_out')->sum('quantity');
        $ironSum = $productionDatas->where('production_type', 'iron')->sum('quantity');
        $packingSum = $productionDatas->where('production_type', 'packing')->sum('quantity');

        if (!$request->filled('type')) {
            $request->type = $production->production_type;
        }

        switch ($request->type) {
            case 'cutting':
                $cuttingSum = $cuttingSum + $request['qty'];
                break;
            case 'swing_in':
                $swing_inSum = $swing_inSum + $request['qty'];
                break;
            case 'swing_out':
                $swing_outSum = $swing_outSum + $request['qty'];
                break;
            case 'iron':
                $ironSum = $ironSum + $request['qty'];
                break;
            case 'packing':
                $packingSum = $packingSum + $request['qty'];
                break;
        }


        $canProductionEntry = false;

        if (($cuttingSum >= $swing_inSum) && ($swing_inSum >= $swing_outSum) && ($swing_outSum >= $ironSum) && ($ironSum >= $packingSum)) {

            $canProductionEntry = true;
            //dd('ok', '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);

        }
        /*else {
            dd('not ok', '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);
        }*/

        if (!$canProductionEntry) {
            //dd( 'if', $canProductionEntry, '$cuttingSum : ' . $cuttingSum, '$swing_inSum : ' . $swing_inSum, '$swing_outSum : ' . $swing_outSum, '$ironSum : ' . $ironSum, '$packingSum : ' . $packingSum);
            return back()->withInput()->with(['fail'=>$this->pageData['pageName'].' quantity mismatch !']);
        }


        /*$model = new Production();
        $model->order_id = $order->id;
        $model->user_id = $loggedUser->id;
        $model->production_type = $request['production_type'];
        $model->order_qty_id = $request['order_quantity_id'];
        $model->quantity = $request['quantity'];
        $model->operation = $request['operation'];
        $model->date = date('Y-m-d');

        if ($request->filled('line_id')) {
            $model->line_id = $request['line_id'];
        }
        if ($request->filled('date')) {
            $model->date = $request['date'];
        }
        if ($request->filled('sub_contract_id')) {
            $model->sub_contract_id = $request['sub_contract_id'];
        }*/



        $production->user_id = $loggedUser->id;
        $production->date = $request->date;
        $production->production_type = $request->type;
        $production->quantity = $request->qty;
        $production->save();

        return back()->with(['success'=>$this->pageData['pageName'].' update Successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Production  $production
     * @return \Illuminate\Http\Response
     */
    public function destroy(Production $production)
    {
        //
    }
}
