<?php

namespace App\Http\Controllers;

use App\Order;
use App\Shipment;
use Illuminate\Http\Request;
use Auth;

class ShipmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());
        $user = Auth::user();
        $request->validate([
            'quantity' => 'required|numeric|min:5',
            'status' => 'required',
        ]);
        $mainData = new Shipment();
        $mainData->user_id = $user->id;
        $mainData->order_id = $request['order_id'];
        $mainData->quantity = $request['quantity'];
        $mainData->date = $request['date'];

        $order = Order::find($request['order_id']);
        $order->statuses = $request['status'];
        $mainData->status = $request['status'];

        $order->save();

        if ($request['date'] == null) {
            $mainData->date = date('Y-m-d');
        }

        $mainData->save();

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Shipment  $shipment
     * @return \Illuminate\Http\Response
     */
    public function show(Shipment $shipment)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Shipment  $shipment
     * @return \Illuminate\Http\Response
     */
    public function edit(Shipment $shipment)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Shipment  $shipment
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Shipment $shipment)
    {
        //dd($request->all());
        $user = Auth::user();
        $request->validate([
            'quantity' => 'required|numeric|min:5',
        ]);
        $mainData = $shipment;
        $mainData->user_id = $user->id;
        $mainData->order_id = $request['order_id'];
        $mainData->quantity = $request['quantity'];
        $mainData->date = $request['date'];
        if ($request->has('status')) {

            $order = Order::find($request['order_id']);

            $order->statuses = $request['status'];

            $mainData->status = $request['status'];

            $order->save();
        }
        if ($request['date'] == null) {
            $mainData->date = date('Y-m-d');
        }

        $mainData->save();

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Shipment  $shipment
     * @return \Illuminate\Http\Response
     */
    public function destroy(Shipment $shipment)
    {
        $user = Auth::user();
        $shipment->user_id = $user->id;
        $shipment->history_type = 'Delete';
        $shipment->save();
        if ($shipment->order->shipment->count() == 0) {
            $shipment->order->statuses = 'Running';
            $shipment->order->save();
        }
        return redirect()->back()->with(['warning'=>'Shipment has been deleted !']);
    }
}
