<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->string('value');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert some stuff
        if (!(App\Setting::where('name', 'companyName')->first())) {
            DB::table('settings')->insert(
                array(
                    'name' => 'companyName',
                    'value' => 'West Apparels',
                    'description' => 'value insert when migrate',
                )
            );
        }

        if (!(App\Setting::where('name', 'shipmentScheduleChartStartMonth')->first())) {
            DB::table('settings')->insert(
                array(
                    'name' => 'shipmentScheduleChartStartMonth',
                    'value' => 'Jan',
                    'description' => 'value insert when migrate',
                )
            );
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
