/*
 Highcharts JS v7.2.0 (2019-09-03)

 Annotations module

 (c) 2009-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/modules/annotations",["highcharts"],function(q){d(q);d.Highcharts=q;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function q(f,g,d,r){f.hasOwnProperty(g)||(f[g]=r.apply(null,d))}d=d?d._modules:{};q(d,"annotations/eventEmitterMixin.js",[d["parts/Globals.js"],d["parts/Utilities.js"]],function(f,g){var d=g.objectEach,r=f.fireEvent;
return{addEvents:function(){var a=this;f.addEvent(a.graphic.element,"mousedown",function(e){a.onMouseDown(e)});d(a.options.events,function(e,c){var b=function(b){"click"===c&&a.cancelClick||e.call(a,a.chart.pointer.normalize(b),a.target)};if(-1===f.inArray(c,a.nonDOMEvents||[]))a.graphic.on(c,b);else f.addEvent(a,c,b)});a.options.draggable&&(f.addEvent(a,"drag",a.onDrag),a.graphic.renderer.styledMode||a.graphic.css({cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[a.options.draggable]}));a.isUpdating||
r(a,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(a){var e=this,c=e.chart.pointer;a.preventDefault&&a.preventDefault();if(2!==a.button){a=c.normalize(a);var b=a.chartX;var l=a.chartY;e.cancelClick=!1;e.removeDrag=f.addEvent(f.doc,"mousemove",function(a){e.hasDragged=!0;a=c.normalize(a);a.prevChartX=b;a.prevChartY=l;r(e,"drag",a);b=a.chartX;l=a.chartY});e.removeMouseUp=f.addEvent(f.doc,
"mouseup",function(b){e.cancelClick=e.hasDragged;e.hasDragged=!1;r(f.pick(e.target,e),"afterUpdate");e.onMouseUp(b)})}},onMouseUp:function(){var a=this.chart,e=this.target||this,c=a.options.annotations;a=a.annotations.indexOf(e);this.removeDocEvents();c[a]=e.options},onDrag:function(a){if(this.chart.isInsidePlot(a.chartX-this.chart.plotLeft,a.chartY-this.chart.plotTop)){var e=this.mouseMoveToTranslation(a);"x"===this.options.draggable&&(e.y=0);"y"===this.options.draggable&&(e.x=0);this.points.length?
this.translate(e.x,e.y):(this.shapes.forEach(function(a){a.translate(e.x,e.y)}),this.labels.forEach(function(a){a.translate(e.x,e.y)}));this.redraw(!1)}},mouseMoveToRadians:function(a,e,c){var b=a.prevChartY-c,l=a.prevChartX-e;c=a.chartY-c;a=a.chartX-e;this.chart.inverted&&(e=l,l=b,b=e,e=a,a=c,c=e);return Math.atan2(c,a)-Math.atan2(b,l)},mouseMoveToTranslation:function(a){var e=a.chartX-a.prevChartX;a=a.chartY-a.prevChartY;if(this.chart.inverted){var c=a;a=e;e=c}return{x:e,y:a}},mouseMoveToScale:function(a,
e,c){e=(a.chartX-e||1)/(a.prevChartX-e||1);a=(a.chartY-c||1)/(a.prevChartY-c||1);this.chart.inverted&&(c=a,a=e,e=c);return{x:e,y:a}},destroy:function(){this.removeDocEvents();f.removeEvent(this);this.hcEvents=null}}});q(d,"annotations/ControlPoint.js",[d["parts/Globals.js"],d["annotations/eventEmitterMixin.js"]],function(f,g){function d(d,a,e,c){this.chart=d;this.target=a;this.options=e;this.index=f.pick(e.index,c)}f.extend(d.prototype,g);d.prototype.nonDOMEvents=["drag"];d.prototype.setVisibility=
function(f){this.graphic.attr("visibility",f?"visible":"hidden");this.options.visible=f};d.prototype.render=function(){var f=this.chart,a=this.options;this.graphic=f.renderer.symbol(a.symbol,0,0,a.width,a.height).add(f.controlPointsGroup).css(a.style);this.setVisibility(a.visible);this.addEvents()};d.prototype.redraw=function(f){this.graphic[f?"animate":"attr"](this.options.positioner.call(this,this.target))};d.prototype.destroy=function(){g.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());
this.options=this.target=this.chart=null};d.prototype.update=function(d){var a=this.chart,e=this.target,c=this.index;d=f.merge(!0,this.options,d);this.destroy();this.constructor(a,e,d,c);this.render(a.controlPointsGroup);this.redraw()};return d});q(d,"annotations/MockPoint.js",[d["parts/Globals.js"],d["parts/Utilities.js"]],function(f,d){function g(a,e,c){this.series={visible:!0,chart:a,getPlotBox:f.Series.prototype.getPlotBox};this.target=e||null;this.options=c;this.applyOptions(this.getOptions())}
var r=d.defined;g.fromPoint=function(a){return new g(a.series.chart,null,{x:a.x,y:a.y,xAxis:a.series.xAxis,yAxis:a.series.yAxis})};g.pointToPixels=function(a,e){var c=a.series,b=c.chart,l=a.plotX,f=a.plotY;b.inverted&&(a.mock?(l=a.plotY,f=a.plotX):(l=b.plotWidth-a.plotY,f=b.plotHeight-a.plotX));c&&!e&&(a=c.getPlotBox(),l+=a.translateX,f+=a.translateY);return{x:l,y:f}};g.pointToOptions=function(a){return{x:a.x,y:a.y,xAxis:a.series.xAxis,yAxis:a.series.yAxis}};f.extend(g.prototype,{mock:!0,hasDynamicOptions:function(){return"function"===
typeof this.options},getOptions:function(){return this.hasDynamicOptions()?this.options(this.target):this.options},applyOptions:function(a){this.command=a.command;this.setAxis(a,"x");this.setAxis(a,"y");this.refresh()},setAxis:function(a,e){e+="Axis";a=a[e];var c=this.series.chart;this.series[e]=a instanceof f.Axis?a:r(a)?c[e][a]||c.get(a):null},toAnchor:function(){var a=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(a[0]=this.plotY,a[1]=this.plotX);return a},getLabelConfig:function(){return{x:this.x,
y:this.y,point:this}},isInsidePane:function(){var a=this.plotX,e=this.plotY,c=this.series.xAxis,b=this.series.yAxis,l=!0;c&&(l=r(a)&&0<=a&&a<=c.len);b&&(l=l&&r(e)&&0<=e&&e<=b.len);return l},refresh:function(){var a=this.series,e=a.xAxis;a=a.yAxis;var c=this.getOptions();e?(this.x=c.x,this.plotX=e.toPixels(c.x,!0)):(this.x=null,this.plotX=c.x);a?(this.y=c.y,this.plotY=a.toPixels(c.y,!0)):(this.y=null,this.plotY=c.y);this.isInside=this.isInsidePane()},translate:function(a,e,c,b){this.hasDynamicOptions()||
(this.plotX+=c,this.plotY+=b,this.refreshOptions())},scale:function(a,e,c,b){if(!this.hasDynamicOptions()){var l=this.plotY*b;this.plotX=(1-c)*a+this.plotX*c;this.plotY=(1-b)*e+l;this.refreshOptions()}},rotate:function(a,e,c){if(!this.hasDynamicOptions()){var b=Math.cos(c);c=Math.sin(c);var l=this.plotX,f=this.plotY;l-=a;f-=e;this.plotX=l*b-f*c+a;this.plotY=l*c+f*b+e;this.refreshOptions()}},refreshOptions:function(){var a=this.series,e=a.xAxis;a=a.yAxis;this.x=this.options.x=e?this.options.x=e.toValue(this.plotX,
!0):this.plotX;this.y=this.options.y=a?a.toValue(this.plotY,!0):this.plotY}});return g});q(d,"annotations/controllable/controllableMixin.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["annotations/ControlPoint.js"],d["annotations/MockPoint.js"]],function(f,d,m,r){var a=d.isObject,e=d.isString,c=d.splat;return{init:function(b,a,c){this.annotation=b;this.chart=b.chart;this.options=a;this.points=[];this.controlPoints=[];this.index=c;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,
arguments)},getPointsOptions:function(){var b=this.options;return b.points||b.point&&c(b.point)},attrsFromOptions:function(b){var a=this.constructor.attrsMap,c={},e,k=this.chart.styledMode;for(e in b){var h=a[e];!h||k&&-1!==["fill","stroke","stroke-width"].indexOf(h)||(c[h]=b[e])}return c},anchor:function(b){var a=b.series.getPlotBox();b=b.mock?b.toAnchor():f.Tooltip.prototype.getAnchor.call({chart:b.series.chart},b);b={x:b[0]+(this.options.x||0),y:b[1]+(this.options.y||0),height:b[2]||0,width:b[3]||
0};return{relativePosition:b,absolutePosition:f.merge(b,{x:b.x+a.translateX,y:b.y+a.translateY})}},point:function(b,c){if(b&&b.series)return b;c&&null!==c.series||(a(b)?c=new r(this.chart,this,b):e(b)?c=this.chart.get(b)||null:"function"===typeof b&&(c=b.call(c,this),c=c.series?c:new r(this.chart,this,b)));return c},linkPoints:function(){var b=this.getPointsOptions(),a=this.points,c=b&&b.length||0,e;for(e=0;e<c;e++){var k=this.point(b[e],a[e]);if(!k){a.length=0;return}k.mock&&k.refresh();a[e]=k}return a},
addControlPoints:function(){var a=this.options.controlPoints;(a||[]).forEach(function(b,c){b=f.merge(this.options.controlPointOptions,b);b.index||(b.index=c);a[c]=b;this.controlPoints.push(new m(this.chart,this,b))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(){this.controlPoints.forEach(function(a){a.render()})},redraw:function(a){this.controlPoints.forEach(function(b){b.redraw(a)})},transform:function(a,c,e,f,k){if(this.chart.inverted){var b=c;c=e;e=b}this.points.forEach(function(b,
h){this.transformPoint(a,c,e,f,k,h)},this)},transformPoint:function(a,c,e,f,k,h){var b=this.points[h];b.mock||(b=this.points[h]=r.fromPoint(b));b[a](c,e,f,k)},translate:function(a,c){this.transform("translate",null,null,a,c)},translatePoint:function(a,c,e){this.transformPoint("translate",null,null,a,c,e)},translateShape:function(a,c){var b=this.annotation.chart,e=this.annotation.userOptions,k=b.annotations.indexOf(this.annotation);b=b.options.annotations[k];this.translatePoint(a,c,0);b[this.collection][this.index].point=
this.options.point;e[this.collection][this.index].point=this.options.point},rotate:function(a,c,e){this.transform("rotate",a,c,e)},scale:function(a,c,e,f){this.transform("scale",a,c,e,f)},setControlPointsVisibility:function(a){this.controlPoints.forEach(function(b){b.setVisibility(a)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(a){a.destroy()});this.options=this.controlPoints=this.points=
this.chart=null;this.annotation&&(this.annotation=null)},update:function(a){var c=this.annotation;a=f.merge(!0,this.options,a);var b=this.graphic.parentGroup;this.destroy();this.constructor(c,a);this.render(b);this.redraw()}}});q(d,"annotations/controllable/markerMixin.js",[d["parts/Globals.js"],d["parts/Utilities.js"]],function(f,d){var g=d.defined,r=d.objectEach,a=d.splat,e={arrow:{tagName:"marker",render:!1,id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 0 L 10 5 L 0 10 Z",
strokeWidth:0}]},"reverse-arrow":{tagName:"marker",render:!1,id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10,children:[{tagName:"path",d:"M 0 5 L 10 0 L 10 10 Z",strokeWidth:0}]}};f.SVGRenderer.prototype.addMarker=function(a,b){var c={id:a},e={stroke:b.color||"none",fill:b.color||"rgba(0, 0, 0, 0.75)"};c.children=b.children.map(function(a){return f.merge(e,a)});b=this.definition(f.merge(!0,{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"},b,c));b.id=a;return b};d=function(a){return function(b){this.attr(a,
"url(#"+b+")")}};d={markerEndSetter:d("marker-end"),markerStartSetter:d("marker-start"),setItemMarkers:function(a){var b=a.options,c=a.chart,e=c.options.defs,d=b.fill,k=g(d)&&"none"!==d?d:b.stroke;["markerStart","markerEnd"].forEach(function(h){var l=b[h],d;if(l){for(d in e){var u=e[d];if(l===u.id&&"marker"===u.tagName){var t=u;break}}t&&(l=a[h]=c.renderer.addMarker((b.id||f.uniqueKey())+"-"+t.id,f.merge(t,{color:k})),a.attr(h,l.attr("id")))}})}};f.SVGRenderer.prototype.definition=function(c){function b(c,
l){var k;a(c).forEach(function(a){var c=e.createElement(a.tagName),h={};r(a,function(a,c){"tagName"!==c&&"children"!==c&&"textContent"!==c&&(h[c]=a)});c.attr(h);c.add(l||e.defs);a.textContent&&c.element.appendChild(f.doc.createTextNode(a.textContent));b(a.children||[],c);k=c});return k}var e=this;return b(c)};f.addEvent(f.Chart,"afterGetContainer",function(){this.options.defs=f.merge(e,this.options.defs||{});r(this.options.defs,function(a){"marker"===a.tagName&&!1!==a.render&&this.renderer.addMarker(a.id,
a)},this)});return d});q(d,"annotations/controllable/ControllablePath.js",[d["parts/Globals.js"],d["annotations/controllable/controllableMixin.js"],d["annotations/controllable/markerMixin.js"]],function(f,d,m){function g(a,c,b){this.init(a,c,b);this.collection="shapes"}var a="rgba(192,192,192,"+(f.svg?.0001:.002)+")";g.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"};f.merge(!0,g.prototype,d,{type:"path",setMarkers:m.setItemMarkers,toD:function(){var a=
this.options.d;if(a)return"function"===typeof a?a.call(this):a;var c=this.points,b=c.length,f=b,d=c[0],g=f&&this.anchor(d).absolutePosition,k=0,h=2;for(a=g&&["M",g.x,g.y];++k<b&&f;)d=c[k],f=d.command||"L",g=this.anchor(d).absolutePosition,"Z"===f?a[++h]=f:(f!==c[k-1].command&&(a[++h]=f),a[++h]=g.x,a[++h]=g.y),f=d.series.visible;return f?this.chart.renderer.crispLine(a,this.graphic.strokeWidth()):null},shouldBeDrawn:function(){return d.shouldBeDrawn.call(this)||!!this.options.d},render:function(e){var c=
this.options,b=this.attrsFromOptions(c);this.graphic=this.annotation.chart.renderer.path(["M",0,0]).attr(b).add(e);c.className&&this.graphic.addClass(c.className);this.tracker=this.annotation.chart.renderer.path(["M",0,0]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(e);this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:a,fill:a,"stroke-width":this.graphic.strokeWidth()+2*c.snap});d.render.call(this);f.extend(this.graphic,{markerStartSetter:m.markerStartSetter,
markerEndSetter:m.markerEndSetter});this.setMarkers(this)},redraw:function(a){var c=this.toD(),b=a?"animate":"attr";c?(this.graphic[b]({d:c}),this.tracker[b]({d:c})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=this.tracker.placed=!!c;d.redraw.call(this,a)}});return g});q(d,"annotations/controllable/ControllableRect.js",[d["parts/Globals.js"],d["annotations/controllable/controllableMixin.js"],d["annotations/controllable/ControllablePath.js"]],
function(f,d,m){function g(a,e,c){this.init(a,e,c);this.collection="shapes"}g.attrsMap=f.merge(m.attrsMap,{width:"width",height:"height"});f.merge(!0,g.prototype,d,{type:"rect",translate:d.translateShape,render:function(a){var e=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(e).add(a);d.render.call(this)},redraw:function(a){var e=this.anchor(this.points[0]).absolutePosition;if(e)this.graphic[a?"animate":"attr"]({x:e.x,y:e.y,width:this.options.width,
height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!e;d.redraw.call(this,a)}});return g});q(d,"annotations/controllable/ControllableCircle.js",[d["parts/Globals.js"],d["annotations/controllable/controllableMixin.js"],d["annotations/controllable/ControllablePath.js"]],function(f,d,m){function g(a,e,c){this.init(a,e,c);this.collection="shapes"}g.attrsMap=f.merge(m.attrsMap,{r:"r"});f.merge(!0,g.prototype,d,{type:"circle",translate:d.translateShape,render:function(a){var e=
this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(e).add(a);d.render.call(this)},redraw:function(a){var e=this.anchor(this.points[0]).absolutePosition;if(e)this.graphic[a?"animate":"attr"]({x:e.x,y:e.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!e;d.redraw.call(this,a)},setRadius:function(a){this.options.r=a}});return g});q(d,"annotations/controllable/ControllableLabel.js",[d["parts/Globals.js"],d["parts/Utilities.js"],
d["annotations/controllable/controllableMixin.js"],d["annotations/MockPoint.js"]],function(f,d,m,r){function a(a,b,e){this.init(a,b,e);this.collection="labels"}var e=d.isNumber;a.shapesWithoutBackground=["connector"];a.alignedPosition=function(a,b){var c=a.align,e=a.verticalAlign,f=(b.x||0)+(a.x||0),k=(b.y||0)+(a.y||0),h,d;"right"===c?h=1:"center"===c&&(h=2);h&&(f+=(b.width-(a.width||0))/h);"bottom"===e?d=1:"middle"===e&&(d=2);d&&(k+=(b.height-(a.height||0))/d);return{x:Math.round(f),y:Math.round(k)}};
a.justifiedOptions=function(a,b,e,f){var c=e.align,k=e.verticalAlign,h=b.box?0:b.padding||0,d=b.getBBox();b={align:c,verticalAlign:k,x:e.x,y:e.y,width:b.width,height:b.height};e=f.x-a.plotLeft;var l=f.y-a.plotTop;f=e+h;0>f&&("right"===c?b.align="left":b.x=-f);f=e+d.width-h;f>a.plotWidth&&("left"===c?b.align="right":b.x=a.plotWidth-f);f=l+h;0>f&&("bottom"===k?b.verticalAlign="top":b.y=-f);f=l+d.height-h;f>a.plotHeight&&("top"===k?b.verticalAlign="bottom":b.y=a.plotHeight-f);return b};a.attrsMap={backgroundColor:"fill",
borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};f.merge(!0,a.prototype,m,{translatePoint:function(a,b){m.translatePoint.call(this,a,b,0)},translate:function(a,b){var c=this.annotation.chart,f=this.annotation.userOptions,e=c.annotations.indexOf(this.annotation);e=c.options.annotations[e];c.inverted&&(c=a,a=b,b=c);this.options.x+=a;this.options.y+=b;e[this.collection][this.index].x=this.options.x;e[this.collection][this.index].y=this.options.y;f[this.collection][this.index].x=
this.options.x;f[this.collection][this.index].y=this.options.y},render:function(c){var b=this.options,f=this.attrsFromOptions(b),e=b.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,b.shape,null,null,b.useHTML,null,"annotation-label").attr(f).add(c);this.annotation.chart.styledMode||("contrast"===e.color&&(e.color=this.annotation.chart.renderer.getContrast(-1<a.shapesWithoutBackground.indexOf(b.shape)?"#FFFFFF":b.backgroundColor)),this.graphic.css(b.style).shadow(b.shadow));b.className&&
this.graphic.addClass(b.className);this.graphic.labelrank=b.labelrank;m.render.call(this)},redraw:function(a){var b=this.options,c=this.text||b.format||b.text,e=this.graphic,d=this.points[0];e.attr({text:c?f.format(c,d.getLabelConfig(),this.annotation.chart.time):b.formatter.call(d,this)});b=this.anchor(d);(c=this.position(b))?(e.alignAttr=c,c.anchorX=b.absolutePosition.x,c.anchorY=b.absolutePosition.y,e[a?"animate":"attr"](c)):e.attr({x:0,y:-9999});e.placed=!!c;m.redraw.call(this,a)},anchor:function(){var a=
m.anchor.apply(this,arguments),b=this.options.x||0,e=this.options.y||0;a.absolutePosition.x-=b;a.absolutePosition.y-=e;a.relativePosition.x-=b;a.relativePosition.y-=e;return a},position:function(c){var b=this.graphic,e=this.annotation.chart,d=this.points[0],g=this.options,k=c.absolutePosition,h=c.relativePosition;if(c=d.series.visible&&r.prototype.isInsidePane.call(d)){if(g.distance)var n=f.Tooltip.prototype.getPosition.call({chart:e,distance:f.pick(g.distance,16)},b.width,b.height,{plotX:h.x,plotY:h.y,
negative:d.negative,ttBelow:d.ttBelow,h:h.height||h.width});else g.positioner?n=g.positioner.call(this):(d={x:k.x,y:k.y,width:0,height:0},n=a.alignedPosition(f.extend(g,{width:b.width,height:b.height}),d),"justify"===this.options.overflow&&(n=a.alignedPosition(a.justifiedOptions(e,b,g,n),d)));g.crop&&(g=n.x-e.plotLeft,d=n.y-e.plotTop,c=e.isInsidePlot(g,d)&&e.isInsidePlot(g+b.width,d+b.height))}return c?n:null}});f.SVGRenderer.prototype.symbols.connector=function(a,b,f,d,g){var c=g&&g.anchorX;g=g&&
g.anchorY;var h=f/2;if(e(c)&&e(g)){var n=["M",c,g];var p=b-g;0>p&&(p=-d-p);p<f&&(h=c<a+f/2?p:f-p);g>b+d?n.push("L",a+h,b+d):g<b?n.push("L",a+h,b):c<a?n.push("L",a,b+d/2):c>a+f&&n.push("L",a+f,b+d/2)}return n||[]};return a});q(d,"annotations/controllable/ControllableImage.js",[d["parts/Globals.js"],d["annotations/controllable/controllableMixin.js"],d["annotations/controllable/ControllableLabel.js"]],function(f,d,m){function g(a,e,c){this.init(a,e,c);this.collection="shapes"}g.attrsMap={width:"width",
height:"height",zIndex:"zIndex"};f.merge(!0,g.prototype,d,{type:"image",translate:d.translateShape,render:function(a){var e=this.attrsFromOptions(this.options),c=this.options;this.graphic=this.annotation.chart.renderer.image(c.src,0,-9E9,c.width,c.height).attr(e).add(a);this.graphic.width=c.width;this.graphic.height=c.height;d.render.call(this)},redraw:function(a){var e=this.anchor(this.points[0]);if(e=m.prototype.position.call(this,e))this.graphic[a?"animate":"attr"]({x:e.x,y:e.y});else this.graphic.attr({x:0,
y:-9E9});this.graphic.placed=!!e;d.redraw.call(this,a)}});return g});q(d,"annotations/annotations.src.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["annotations/controllable/controllableMixin.js"],d["annotations/controllable/ControllableRect.js"],d["annotations/controllable/ControllableCircle.js"],d["annotations/controllable/ControllablePath.js"],d["annotations/controllable/ControllableImage.js"],d["annotations/controllable/ControllableLabel.js"],d["annotations/eventEmitterMixin.js"],d["annotations/MockPoint.js"],
d["annotations/ControlPoint.js"]],function(f,d,m,r,a,e,c,b,l,q,x){var k=d.defined,h=d.erase,g=d.splat,p=f.merge,u=f.addEvent,t=f.fireEvent,w=f.find,y=f.pick,z=f.reduce,A=f.destroyObjectProperties;d=f.Chart.prototype;var v=f.Annotation=function(a,b){this.chart=a;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=b;this.userOptions=p(!0,{},b);var c=this.getLabelsAndShapesOptions(this.userOptions,b);this.userOptions.labels=c.labels;this.userOptions.shapes=
c.shapes;this.init(a,b)};p(!0,v.prototype,m,l,{nonDOMEvents:["add","afterUpdate","remove"],defaultOptions:{visible:!0,draggable:"xy",labelOptions:{align:"center",allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:"black",borderRadius:3,borderWidth:1,className:"",crop:!1,formatter:function(){return k(this.y)?this.y:"Annotation label"},overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",
x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",width:10,height:10,style:{stroke:"black","stroke-width":2,fill:"white"},visible:!1,events:{}},events:{},zIndex:6},init:function(){this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.addClipPaths();this.setLabelCollector()},getLabelsAndShapesOptions:function(a,b){var c={};["labels","shapes"].forEach(function(e){a[e]&&(c[e]=g(b[e]).map(function(b,
c){return p(a[e][c],b)}))});return c},addShapes:function(){(this.options.shapes||[]).forEach(this.initShape,this)},addLabels:function(){(this.options.labels||[]).forEach(this.initLabel,this)},addClipPaths:function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))},setClipAxes:function(){var a=this.chart.xAxis,b=this.chart.yAxis,c=z((this.options.labels||[]).concat(this.options.shapes||[]),function(c,e){return[a[e&&e.point&&e.point.xAxis]||
c[0],b[e&&e.point&&e.point.yAxis]||c[1]]},[]);this.clipXAxis=c[0];this.clipYAxis=c[1]},getClipBox:function(){return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}},setLabelCollector:function(){var a=this;a.labelCollector=function(){return a.labels.reduce(function(a,b){b.options.allowOverlap||a.push(b.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)},setOptions:function(a){this.options=p(this.defaultOptions,a)},redraw:function(a){this.linkPoints();
this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);m.redraw.call(this,a)},redrawItems:function(a,b){for(var c=a.length;c--;)this.redrawItem(a[c],b)},render:function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic).clip(this.chart.plotBoxClip);
this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.clipRect&&this.graphic.clip(this.clipRect);this.addEvents();m.render.call(this)},setVisibility:function(a){var b=this.options;a=y(a,!b.visible);this.graphic.attr("visibility",a?"visible":"hidden");a||this.setControlPointsVisibility(!1);b.visible=a},setControlPointsVisibility:function(a){var b=function(b){b.setControlPointsVisibility(a)};m.setControlPointsVisibility.call(this,a);this.shapes.forEach(b);
this.labels.forEach(b)},destroy:function(){var a=this.chart,b=function(a){a.destroy()};this.labels.forEach(b);this.shapes.forEach(b);this.clipYAxis=this.clipXAxis=null;h(a.labelCollectors,this.labelCollector);l.destroy.call(this);m.destroy.call(this);A(this,a)},remove:function(){return this.chart.removeAnnotation(this)},update:function(a){var b=this.chart,c=this.getLabelsAndShapesOptions(this.userOptions,a),e=b.annotations.indexOf(this);a=f.merge(!0,this.userOptions,a);a.labels=c.labels;a.shapes=
c.shapes;this.destroy();this.constructor(b,a);b.options.annotations[e]=a;this.isUpdating=!0;this.redraw();this.isUpdating=!1;t(this,"afterUpdate")},initShape:function(a,b){a=p(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},a);b=new v.shapesMap[a.type](this,a,b);b.itemType="shape";this.shapes.push(b);return b},initLabel:function(a,c){a=p(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},a);c=new b(this,a,c);c.itemType="label";this.labels.push(c);
return c},redrawItem:function(a,b){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(f.pick(b,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):this.destroyItem(a)},adjustVisibility:function(a){var b=!1,c=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(b=!0)});b?"hidden"===c.visibility&&c.show():c.hide()},destroyItem:function(a){h(this[a.itemType+"s"],a);a.destroy()},renderItem:function(a){a.render("label"===a.itemType?this.labelsGroup:
this.shapesGroup)}});v.shapesMap={rect:r,circle:a,path:e,image:c};v.types={};v.MockPoint=q;v.ControlPoint=x;f.extendAnnotation=function(a,b,c,e){b=b||v;p(!0,a.prototype,b.prototype,c);a.prototype.defaultOptions=p(a.prototype.defaultOptions,e||{})};f.extend(d,{initAnnotation:function(a){var b=v.types[a.type]||v;a=f.merge(b.prototype.defaultOptions,a);b=new b(this,a);this.annotations.push(b);return b},addAnnotation:function(a,b){a=this.initAnnotation(a);this.options.annotations.push(a.options);y(b,
!0)&&a.redraw();return a},removeAnnotation:function(a){var b=this.annotations,c="annotations"===a.coll?a:w(b,function(b){return b.options.id===a});c&&(t(c,"remove"),h(this.options.annotations,c.options),h(b,c),c.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(a){a.redraw()})}});d.collectionsWithUpdate.push("annotations");d.collectionsWithInit.annotations=[d.addAnnotation];d.callbacks.push(function(a){a.annotations=[];a.options.annotations||
(a.options.annotations=[]);a.plotBoxClip=this.renderer.clipRect(this.plotBox);a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(b,c){b=a.initAnnotation(b);a.options.annotations[c]=b.options});a.drawAnnotations();u(a,"redraw",a.drawAnnotations);u(a,"destroy",function(){a.plotBoxClip.destroy();a.controlPointsGroup.destroy()})})});q(d,"mixins/navigation.js",[],function(){return{initUpdate:function(f){f.navigation||(f.navigation=
{updates:[],update:function(f,d){this.updates.forEach(function(g){g.update.call(g.context,f,d)})}})},addUpdate:function(f,d){d.navigation||this.initUpdate(d);d.navigation.updates.push({update:f,context:d})}}});q(d,"annotations/navigationBindings.js",[d["parts/Globals.js"],d["parts/Utilities.js"],d["mixins/navigation.js"]],function(d,g,m){function f(a){var b=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;d.merge(!0,a.prototype.defaultOptions.events,{click:function(a){var c=
this,d=c.chart.navigationBindings,e=d.activeAnnotation;b&&b.click.call(c,a);e!==c?(d.deselectAnnotation(),d.activeAnnotation=c,c.setControlPointsVisibility(!0),p(d,"showPopup",{annotation:c,formType:"annotation-toolbar",options:d.annotationToFields(c),onSubmit:function(a){var b={};"remove"===a.actionType?(d.activeAnnotation=!1,d.chart.removeAnnotation(c)):(d.fieldsToOptions(a.fields,b),d.deselectAnnotation(),a=b.typeOptions,"measure"===c.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,
a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),c.update(b))}})):(d.deselectAnnotation(),p(d,"closePopup"));a.activeAnnotation=!0}})}var a=g.attr,e=g.isArray,c=g.isNumber,b=g.isObject,l=g.objectEach,q=d.doc,x=d.win,k=d.addEvent,h=d.pick,n=d.merge;g=d.extend;var p=d.fireEvent;d.NavigationBindings=function(a,b){this.chart=a;this.options=b;this.eventsToUnbind=[];this.container=q.getElementsByClassName(this.options.bindingsClassName)};d.NavigationBindings.annotationsEditable={nestedOptions:{labelOptions:["style",
"format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill","strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],verticalLine:[],
label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[]};d.NavigationBindings.annotationsNonEditable={rectangle:["crosshairX","crosshairY","label"]};g(d.NavigationBindings.prototype,{initEvents:function(){var a=this,b=a.chart,c=a.container,e=a.options;a.boundClassNames={};l(e.bindings,function(b){a.boundClassNames[b.className]=b});[].forEach.call(c,function(b){a.eventsToUnbind.push(k(b,
"click",function(b){var d=a.getButtonEvents(c,b);d&&a.bindingsButtonClick(d.button,d.events,b)}))});l(e.events||{},function(b,c){d.isFunction(b)&&a.eventsToUnbind.push(k(a,c,b))});a.eventsToUnbind.push(k(b.container,"click",function(c){!b.cancelClick&&b.isInsidePlot(c.chartX-b.plotLeft,c.chartY-b.plotTop)&&a.bindingsChartClick(this,c)}));a.eventsToUnbind.push(k(b.container,"mousemove",function(b){a.bindingsContainerMouseMove(this,b)}))},initUpdate:function(){var a=this;m.addUpdate(function(b){a.update(b)},
this.chart)},bindingsButtonClick:function(a,b,c){var d=this.chart;this.selectedButtonElement&&(p(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&d.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));this.selectedButton=b;this.selectedButtonElement=a;p(this,"selectButton",{button:a});b.init&&b.init.call(this,a,c);(b.start||b.steps)&&d.renderer.boxWrapper.addClass("highcharts-draw-mode")},
bindingsChartClick:function(a,b){a=this.selectedButton;var c=this.chart.renderer.boxWrapper,d;if(d=this.activeAnnotation&&!b.activeAnnotation&&b.target.parentNode){a:{d=b.target;var e=x.Element.prototype,f=e.matches||e.msMatchesSelector||e.webkitMatchesSelector,h=null;if(e.closest)h=e.closest.call(d,".highcharts-popup");else{do{if(f.call(d,".highcharts-popup"))break a;d=d.parentElement||d.parentNode}while(null!==d&&1===d.nodeType)}d=h}d=!d}d&&(p(this,"closePopup"),this.deselectAnnotation());a&&a.start&&
(this.nextEvent?(this.nextEvent(b,this.currentUserDetails),this.steps&&(this.stepIndex++,a.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=a.steps[this.stepIndex]:(p(this,"deselectButton",{button:this.selectedButtonElement}),c.removeClass("highcharts-draw-mode"),a.end&&a.end.call(this,b,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null))):(this.currentUserDetails=a.start.call(this,b),a.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=
a.steps[this.stepIndex]):(p(this,"deselectButton",{button:this.selectedButtonElement}),c.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,a.end&&a.end.call(this,b,this.currentUserDetails))))},bindingsContainerMouseMove:function(a,b){this.mouseMoveEvent&&this.mouseMoveEvent(b,this.currentUserDetails)},fieldsToOptions:function(a,b){l(a,function(a,d){var e=parseFloat(a),f=d.split("."),k=b,u=f.length-1;!c(e)||a.match(/px/g)||d.match(/format/g)||(a=e);""!==a&&"undefined"!==a&&
f.forEach(function(b,c){var d=h(f[c+1],"");u===c?k[b]=a:(k[b]||(k[b]=d.match(/\d/g)?[]:{}),k=k[b])})});return b},deselectAnnotation:function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)},annotationToFields:function(a){function c(f,h,k,t){if(k&&-1===p.indexOf(h)&&(0<=(k.indexOf&&k.indexOf(h))||k[h]||!0===k))if(e(f))t[h]=[],f.forEach(function(a,d){b(a)?(t[h][d]={},l(a,function(a,b){c(a,b,u[h],t[h][d])})):c(a,0,u[h],t[h])});else if(b(f)){var w=
{};e(t)?(t.push(w),w[h]={},w=w[h]):t[h]=w;l(f,function(a,b){c(a,b,0===h?k:u[h],w)})}else"format"===h?t[h]=[d.format(f,a.labels[0].points[0]).toString(),"text"]:e(t)?t.push([f,g(f)]):t[h]=[f,g(f)]}var f=a.options,k=d.NavigationBindings.annotationsEditable,u=k.nestedOptions,g=this.utils.getFieldType,n=h(f.type,f.shapes&&f.shapes[0]&&f.shapes[0].type,f.labels&&f.labels[0]&&f.labels[0].itemType,"label"),p=d.NavigationBindings.annotationsNonEditable[f.langKey]||[],m={langKey:f.langKey,type:n};l(f,function(a,
b){"typeOptions"===b?(m[b]={},l(f[b],function(a,d){c(a,d,u,m[b],!0)})):c(a,b,k[n],m)});return m},getClickedClassNames:function(b,c){var d=c.target;c=[];for(var e;d&&((e=a(d,"class"))&&(c=c.concat(e.split(" ").map(function(a){return[a,d]}))),d=d.parentNode,d!==b););return c},getButtonEvents:function(a,b){var c=this,d;this.getClickedClassNames(a,b).forEach(function(a){c.boundClassNames[a[0]]&&!d&&(d={events:c.boundClassNames[a[0]],button:a[1]})});return d},update:function(a){this.options=n(!0,this.options,
a);this.removeEvents();this.initEvents()},removeEvents:function(){this.eventsToUnbind.forEach(function(a){a()})},destroy:function(){this.removeEvents()},utils:{updateRectSize:function(a,b){var c=b.chart,d=b.options.typeOptions,e=c.pointer.getCoordinates(a);a=e.xAxis[0].value-d.point.x;d=d.point.y-e.yAxis[0].value;b.update({typeOptions:{background:{width:c.inverted?d:a,height:c.inverted?a:d}}})},getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]}}});d.Chart.prototype.initNavigationBindings=
function(){var a=this.options;a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new d.NavigationBindings(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};k(d.Chart,"load",function(){this.initNavigationBindings()});k(d.Chart,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});k(d.NavigationBindings,"deselectButton",function(){this.selectedButtonElement=null});k(d.Annotation,"remove",function(){this.chart.navigationBindings&&
this.chart.navigationBindings.deselectAnnotation()});d.Annotation&&(f(d.Annotation),l(d.Annotation.types,function(a){f(a)}));d.setOptions({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",
borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.chart.options.navigation;return this.chart.addAnnotation(n({langKey:"circle",shapes:[{type:"circle",point:{xAxis:0,
yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},r:5,controlPoints:[{positioner:function(a){var b=d.Annotation.MockPoint.pointToPixels(a.points[0]);a=a.options.r;return{x:b.x+a*Math.cos(Math.PI/4)-this.graphic.width/2,y:b.y+a*Math.sin(Math.PI/4)-this.graphic.height/2}},events:{drag:function(a,b){var c=b.annotation;a=this.mouseMoveToTranslation(a);b.setRadius(Math.max(b.options.r+a.y/Math.sin(Math.PI/4),5));c.options.shapes[0]=c.userOptions.shapes[0]=b.options;b.redraw(!1)}}}]}]},b.annotationsOptions,
b.bindings.circleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].point,d=this.chart.xAxis[0].toPixels(c.x);c=this.chart.yAxis[0].toPixels(c.y);var e=this.chart.inverted;b.update({shapes:[{r:Math.max(Math.sqrt(Math.pow(e?c-a.chartX:d-a.chartX,2)+Math.pow(e?d-a.chartY:c-a.chartY,2)),5)}]})}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.chart.options.navigation;var c=b.xAxis[0].value;
b=b.yAxis[0].value;return this.chart.addAnnotation(n({langKey:"rectangle",shapes:[{type:"path",points:[{xAxis:0,yAxis:0,x:c,y:b},{xAxis:0,yAxis:0,x:c,y:b},{xAxis:0,yAxis:0,x:c,y:b},{xAxis:0,yAxis:0,x:c,y:b}]}],controlPoints:[{positioner:function(a){a=d.Annotation.MockPoint.pointToPixels(a.shapes[0].points[2]);return{x:a.x-4,y:a.y-4}},events:{drag:function(a,b){var c=this.chart.pointer.getCoordinates(a);a=c.xAxis[0].value;c=c.yAxis[0].value;var d=b.options.shapes[0].points;d[1].x=a;d[2].x=a;d[2].y=
c;d[3].y=c;b.options.shapes[0].points=d;b.redraw(!1)}}}]},a.annotationsOptions,a.bindings.rectangleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].points,d=this.chart.pointer.getCoordinates(a);a=d.xAxis[0].value;d=d.yAxis[0].value;c[1].x=a;c[2].x=a;c[2].y=d;c[3].y=d;b.update({shapes:[{points:c}]})}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.chart.options.navigation;return this.chart.addAnnotation(n({langKey:"label",
labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:0,yAxis:0,x:a.xAxis[0].value,y:a.yAxis[0].value},overflow:"none",crop:!0,controlPoints:[{symbol:"triangle-down",positioner:function(a){if(!a.graphic.placed)return{x:0,y:-9E7};a=d.Annotation.MockPoint.pointToPixels(a.points[0]);return{x:a.x-this.graphic.width/2,y:a.y-this.graphic.height/2}},events:{drag:function(a,b){a=this.mouseMoveToTranslation(a);b.translatePoint(a.x,a.y);b.annotation.labels[0].options=b.options;b.redraw(!1)}}},{symbol:"square",
positioner:function(a){return a.graphic.placed?{x:a.graphic.alignAttr.x-this.graphic.width/2,y:a.graphic.alignAttr.y-this.graphic.height/2}:{x:0,y:-9E7}},events:{drag:function(a,b){a=this.mouseMoveToTranslation(a);b.translate(a.x,a.y);b.annotation.labels[0].options=b.options;b.redraw(!1)}}}]}]},b.annotationsOptions,b.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{}}})});q(d,"annotations/popup.js",[d["parts/Globals.js"],d["parts/Utilities.js"]],function(d,g){var f=g.defined,
r=g.isArray,a=g.isObject,e=g.isString,c=g.objectEach,b=d.addEvent,l=d.createElement,q=d.pick;g=d.wrap;var x=/\d/g;g(d.Pointer.prototype,"onContainerMouseDown",function(a,b){var c=b.target&&b.target.className;e(c)&&0<=c.indexOf("highcharts-popup-field")||a.apply(this,Array.prototype.slice.call(arguments,1))});d.Popup=function(a,b){this.init(a,b)};d.Popup.prototype={init:function(a,b){this.container=l("div",{className:"highcharts-popup"},null,a);this.lang=this.getLangpack();this.iconsURL=b;this.addCloseBtn()},
addCloseBtn:function(){var a=this;var c=l("div",{className:"highcharts-popup-close"},null,this.container);c.style["background-image"]="url("+this.iconsURL+"close.svg)";["click","touchstart"].forEach(function(d){b(c,d,function(){a.closePopup()})})},addColsContainer:function(a){var b=l("div",{className:"highcharts-popup-lhs-col"},null,a);a=l("div",{className:"highcharts-popup-rhs-col"},null,a);l("div",{className:"highcharts-popup-rhs-col-wrapper"},null,a);return{lhsCol:b,rhsCol:a}},addInput:function(a,
b,c,d){var e=a.split(".");e=e[e.length-1];var f=this.lang;b="highcharts-"+b+"-"+e;b.match(x)||l("label",{innerHTML:f[e]||e,htmlFor:b},null,c);l("input",{name:b,value:d[0],type:d[1],className:"highcharts-popup-field"},null,c).setAttribute("highcharts-data-name",a)},addButton:function(a,c,d,e,f){var h=this,k=this.closePopup,g=this.getFields;var n=l("button",{innerHTML:c},null,a);["click","touchstart"].forEach(function(a){b(n,a,function(){k.call(h);return e(g(f,d))})});return n},getFields:function(a,
b){var c=a.querySelectorAll("input"),d=a.querySelectorAll("#highcharts-select-series > option:checked")[0];a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];var e,f;var h={actionType:b,linkedTo:d&&d.getAttribute("value"),fields:{}};[].forEach.call(c,function(a){f=a.getAttribute("highcharts-data-name");(e=a.getAttribute("highcharts-data-series-id"))?h.seriesId=a.value:f?h.fields[f]=a.value:h.type=a.value});a&&(h.fields["params.volumeSeriesID"]=a.getAttribute("value"));return h},
showPopup:function(){var a=this.container,b=a.querySelectorAll(".highcharts-popup-close")[0];a.innerHTML="";0<=a.className.indexOf("highcharts-annotation-toolbar")&&(a.classList.remove("highcharts-annotation-toolbar"),a.removeAttribute("style"));a.appendChild(b);a.style.display="block"},closePopup:function(){this.popup.container.style.display="none"},showForm:function(a,b,c,d){this.popup=b.navigationBindings.popup;this.showPopup();"indicators"===a&&this.indicators.addForm.call(this,b,c,d);"annotation-toolbar"===
a&&this.annotations.addToolbar.call(this,b,c,d);"annotation-edit"===a&&this.annotations.addForm.call(this,b,c,d);"flag"===a&&this.annotations.addForm.call(this,b,c,d,!0)},getLangpack:function(){return d.getOptions().lang.navigation.popup},annotations:{addToolbar:function(a,b,c){var d=this,e=this.lang,f=this.popup.container,h=this.showForm;-1===f.className.indexOf("highcharts-annotation-toolbar")&&(f.className+=" highcharts-annotation-toolbar");f.style.top=a.plotTop+10+"px";l("span",{innerHTML:q(e[b.langKey]||
b.langKey,b.shapes&&b.shapes[0].type)},null,f);var k=this.addButton(f,e.removeButton||"remove","remove",c,f);k.className+=" highcharts-annotation-remove-button";k.style["background-image"]="url("+this.iconsURL+"destroy.svg)";k=this.addButton(f,e.editButton||"edit","edit",function(){h.call(d,"annotation-edit",a,b,c)},f);k.className+=" highcharts-annotation-edit-button";k.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(a,b,c,d){var e=this.popup.container,f=this.lang;l("h2",
{innerHTML:f[b.langKey]||b.langKey,className:"highcharts-popup-main-title"},null,e);var h=l("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},null,e);var k=l("div",{className:"highcharts-popup-bottom-row"},null,e);this.annotations.addFormFields.call(this,h,a,"",b,[],!0);this.addButton(k,d?f.addButton||"add":f.saveButton||"save",d?"add":"save",c,e)},addFormFields:function(b,d,e,f,g,t){var h=this,k=this.annotations.addFormFields,n=this.addInput,p=this.lang,u,m;c(f,function(c,f){u=
""!==e?e+"."+f:f;a(c)&&(!r(c)||r(c)&&a(c[0])?(m=p[f]||f,m.match(x)||g.push([!0,m,b]),k.call(h,b,d,u,c,g,!1)):g.push([h,u,"annotation",b,c]))});t&&(g=g.sort(function(a){return a[1].match(/format/g)?-1:1}),g.forEach(function(a){!0===a[0]?l("span",{className:"highcharts-annotation-title",innerHTML:a[1]},null,a[2]):n.apply(a[0],a.splice(1))}))}},indicators:{addForm:function(a,b,c){var d=this.indicators,e=this.lang;this.tabs.init.call(this,a);b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");
this.addColsContainer(b[0]);d.addIndicatorList.call(this,a,b[0],"add");var f=b[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.addButton||"add","add",c,f);this.addColsContainer(b[1]);d.addIndicatorList.call(this,a,b[1],"edit");f=b[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.saveButton||"save","edit",c,f);this.addButton(f,e.removeButton||"remove","remove",c,f)},addIndicatorList:function(a,d,e){var f=this,h=d.querySelectorAll(".highcharts-popup-lhs-col")[0];
d=d.querySelectorAll(".highcharts-popup-rhs-col")[0];var k="edit"===e,g=k?a.series:a.options.plotOptions,n=this.indicators.addFormFields,m;var q=l("ul",{className:"highcharts-indicator-list"},null,h);var r=d.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];c(g,function(c,d){var e=c.options;if(c.params||e&&e.params){var h=f.indicators.getNameType(c,d),p=h.type;m=l("li",{className:"highcharts-indicator-list",innerHTML:h.name},null,q);["click","touchstart"].forEach(function(d){b(m,d,function(){n.call(f,
a,k?c:g[p],h.type,r);k&&c.options&&l("input",{type:"hidden",name:"highcharts-id-"+p,value:c.options.id},null,r).setAttribute("highcharts-data-series-id",c.options.id)})})}});0<q.childNodes.length&&q.childNodes[0].click()},getNameType:function(a,b){var c=a.options,e=d.seriesTypes;e=e[b]&&e[b].prototype.nameBase||b.toUpperCase();c&&c.type&&(b=a.options.type,e=a.name);return{name:e,type:b}},listAllSeries:function(a,b,c,d,e){a="highcharts-"+b+"-type-"+a;var h;l("label",{innerHTML:this.lang[b]||b,htmlFor:a},
null,d);var k=l("select",{name:a,className:"highcharts-popup-field"},null,d);k.setAttribute("id","highcharts-select-"+b);c.series.forEach(function(a){h=a.options;!h.params&&h.id&&"highcharts-navigator-series"!==h.id&&l("option",{innerHTML:h.name||h.id,value:h.id},null,k)});f(e)&&(k.value=e)},addFormFields:function(a,b,c,d){var e=b.params||b.options.params,f=this.indicators.getNameType;d.innerHTML="";l("h3",{className:"highcharts-indicator-title",innerHTML:f(b,c).name},null,d);l("input",{type:"hidden",
name:"highcharts-type-"+c,value:c},null,d);this.indicators.listAllSeries.call(this,c,"series",a,d,b.linkedParent&&e.volumeSeriesID);e.volumeSeriesID&&this.indicators.listAllSeries.call(this,c,"volume",a,d,b.linkedParent&&b.linkedParent.options.id);this.indicators.addParamInputs.call(this,a,"params",e,c,d)},addParamInputs:function(b,d,e,f,g){var h=this,k=this.indicators.addParamInputs,l=this.addInput,n;c(e,function(c,e){n=d+"."+e;a(c)?k.call(h,b,n,c,f,g):"params.volumeSeriesID"!==n&&l.call(h,n,f,g,
[c,"text"])})},getAmount:function(){var a=0;c(this.series,function(b){var c=b.options;(b.params||c&&c.params)&&a++});return a}},tabs:{init:function(a){var b=this.tabs;a=this.indicators.getAmount.call(a);var c=b.addMenuItem.call(this,"add");b.addMenuItem.call(this,"edit",a);b.addContentItem.call(this,"add");b.addContentItem.call(this,"edit");b.switchTabs.call(this,a);b.selectTab.call(this,c,0)},addMenuItem:function(a,b){var c=this.popup.container,d="highcharts-tab-item",e=this.lang;0===b&&(d+=" highcharts-tab-disabled");
b=l("span",{innerHTML:e[a+"Button"]||a,className:d},null,c);b.setAttribute("highcharts-data-tab-type",a);return b},addContentItem:function(){return l("div",{className:"highcharts-tab-item-content"},null,this.popup.container)},switchTabs:function(a){var c=this,d;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(e,f){d=e.getAttribute("highcharts-data-tab-type");"edit"===d&&0===a||["click","touchstart"].forEach(function(a){b(e,a,function(){c.tabs.deselectAll.call(c);c.tabs.selectTab.call(c,
this,f)})})})},selectTab:function(a,b){var c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";c[b].className+=" highcharts-tab-item-show"},deselectAll:function(){var a=this.popup.container,b=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var c;for(c=0;c<b.length;c++)b[c].classList.remove("highcharts-tab-item-active"),a[c].classList.remove("highcharts-tab-item-show")}}};b(d.NavigationBindings,
"showPopup",function(a){this.popup||(this.popup=new d.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/7.2.0/gfx/stock-icons/"));this.popup.showForm(a.formType,this.chart,a.options,a.onSubmit)});b(d.NavigationBindings,"closePopup",function(){this.popup&&this.popup.closePopup()})});q(d,"masters/modules/annotations.src.js",[],function(){})});
//# sourceMappingURL=annotations.js.map