/*
 Highmaps JS v7.2.0 (2019-09-03)

 Highmaps as a plugin for Highcharts or Highstock.

 (c) 2011-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(A){"object"===typeof module&&module.exports?(A["default"]=A,module.exports=A):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(z){A(z);A.Highcharts=z;return A}):A("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(A){function z(a,g,t,p){a.hasOwnProperty(g)||(a[g]=p.apply(null,t))}var m=A?A._modules:{};z(m,"parts-map/MapAxis.js",[m["parts/Globals.js"]],function(a){var g=a.addEvent,t=a.Axis,p=a.pick;g(t,"getSeriesExtremes",function(){var a=
[];this.isXAxis&&(this.series.forEach(function(d,w){d.useMapGeometry&&(a[w]=d.xData,d.xData=[])}),this.seriesXData=a)});g(t,"afterGetSeriesExtremes",function(){var a=this.seriesXData,d;if(this.isXAxis){var g=p(this.dataMin,Number.MAX_VALUE);var t=p(this.dataMax,-Number.MAX_VALUE);this.series.forEach(function(w,f){w.useMapGeometry&&(g=Math.min(g,p(w.minX,g)),t=Math.max(t,p(w.maxX,t)),w.xData=a[f],d=!0)});d&&(this.dataMin=g,this.dataMax=t);delete this.seriesXData}});g(t,"afterSetAxisTranslation",function(){var a=
this.chart;var d=a.plotWidth/a.plotHeight;a=a.xAxis[0];var g;"yAxis"===this.coll&&void 0!==a.transA&&this.series.forEach(function(a){a.preserveAspectRatio&&(g=!0)});if(g&&(this.transA=a.transA=Math.min(this.transA,a.transA),d/=(a.max-a.min)/(this.max-this.min),d=1>d?this:a,a=(d.max-d.min)*d.transA,d.pixelPadding=d.len-a,d.minPixelPadding=d.pixelPadding/2,a=d.fixTo)){a=a[1]-d.toValue(a[0],!0);a*=d.transA;if(Math.abs(a)>d.minPixelPadding||d.min===d.dataMin&&d.max===d.dataMax)a=0;d.minPixelPadding-=
a}});g(t,"render",function(){this.fixTo=null})});z(m,"parts-map/ColorSeriesMixin.js",[m["parts/Globals.js"]],function(a){a.colorPointMixin={setVisible:function(a){var g=this,p=a?"show":"hide";g.visible=!!a;["graphic","dataLabel"].forEach(function(a){if(g[a])g[a][p]()})}};a.colorSeriesMixin={optionalAxis:"colorAxis",colorAxis:0,translateColors:function(){var a=this,t=this.options.nullColor,p=this.colorAxis,w=this.colorKey;(this.data.length?this.data:this.points).forEach(function(d){var g=d[w];if(g=
d.options.color||(d.isNull?t:p&&void 0!==g?p.toColor(g,d):d.color||a.color))d.color=g})}}});z(m,"parts-map/ColorAxis.js",[m["parts/Globals.js"],m["parts/Utilities.js"]],function(a,g){var t=g.erase,p=g.isNumber,w=g.splat;g=a.addEvent;var d=a.Axis,m=a.Chart,x=a.Series,r=a.Point,f=a.color,b=a.extend,l=a.Legend,v=a.LegendSymbolMixin,k=a.colorPointMixin,u=a.noop,e=a.merge,n=a.pick;b(x.prototype,a.colorSeriesMixin);b(r.prototype,k);var c=a.ColorAxis=function(){this.init.apply(this,arguments)};b(c.prototype,
d.prototype);b(c.prototype,{defaultColorAxisOptions:{lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{overflow:"justify",rotation:0},minColor:"#e6ebf5",maxColor:"#003399",tickLength:5,showInLegend:!0},keepProps:["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"].concat(d.prototype.keepProps),init:function(h,c){this.coll="colorAxis";var q=this.buildOptions.call(h,
this.defaultColorAxisOptions,c);d.prototype.init.call(this,h,q);c.dataClasses&&this.initDataClasses(c);this.initStops();this.horiz=!q.opposite;this.zoomEnabled=!1;this.defaultLegendLength=200},initDataClasses:function(h){var c=this.chart,a,b=0,n=c.options.chart.colorCount,B=this.options,d=h.dataClasses.length;this.dataClasses=a=[];this.legendItems=[];h.dataClasses.forEach(function(h,q){h=e(h);a.push(h);if(c.styledMode||!h.color)"category"===B.dataClassColor?(c.styledMode||(q=c.options.colors,n=q.length,
h.color=q[b]),h.colorIndex=b,b++,b===n&&(b=0)):h.color=f(B.minColor).tweenTo(f(B.maxColor),2>d?.5:q/(d-1))})},hasData:function(){return!(!this.tickPositions||!this.tickPositions.length)},setTickPositions:function(){if(!this.dataClasses)return d.prototype.setTickPositions.call(this)},initStops:function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(h){h.color=f(h[1])})},buildOptions:function(h,c){var a=this.options.legend,q=c.layout?
"vertical"!==c.layout:"vertical"!==a.layout;return e(h,{side:q?2:1,reversed:!q},c,{opposite:!q,showEmpty:!1,title:null,visible:a.enabled&&(c?!1!==c.visible:!0)})},setOptions:function(h){d.prototype.setOptions.call(this,h);this.options.crosshair=this.options.marker},setAxisSize:function(){var h=this.legendSymbol,c=this.chart,a=c.options.legend||{},e,b;h?(this.left=a=h.attr("x"),this.top=e=h.attr("y"),this.width=b=h.attr("width"),this.height=h=h.attr("height"),this.right=c.chartWidth-a-b,this.bottom=
c.chartHeight-e-h,this.len=this.horiz?b:h,this.pos=this.horiz?a:e):this.len=(this.horiz?a.symbolWidth:a.symbolHeight)||this.defaultLegendLength},normalizedValue:function(h){this.isLog&&(h=this.val2lin(h));return 1-(this.max-h)/(this.max-this.min||1)},toColor:function(h,c){var a=this.stops,e=this.dataClasses,q;if(e)for(q=e.length;q--;){var b=e[q];var n=b.from;a=b.to;if((void 0===n||h>=n)&&(void 0===a||h<=a)){var f=b.color;c&&(c.dataClass=q,c.colorIndex=b.colorIndex);break}}else{h=this.normalizedValue(h);
for(q=a.length;q--&&!(h>a[q][0]););n=a[q]||a[q+1];a=a[q+1]||n;h=1-(a[0]-h)/(a[0]-n[0]||1);f=n.color.tweenTo(a.color,h)}return f},getOffset:function(){var h=this.legendGroup,c=this.chart.axisOffset[this.side];h&&(this.axisParent=h,d.prototype.getOffset.call(this),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=c)},setLegendColor:function(){var h=this.reversed;var c=h?1:0;h=h?0:1;c=this.horiz?[c,0,h,0]:[0,h,0,c];this.legendColor={linearGradient:{x1:c[0],
y1:c[1],x2:c[2],y2:c[3]},stops:this.stops}},drawLegendSymbol:function(h,c){var a=h.padding,e=h.options,q=this.horiz,b=n(e.symbolWidth,q?this.defaultLegendLength:12),f=n(e.symbolHeight,q?12:this.defaultLegendLength),d=n(e.labelPadding,q?16:30);e=n(e.itemDistance,10);this.setLegendColor();c.legendSymbol=this.chart.renderer.rect(0,h.baseline-11,b,f).attr({zIndex:1}).add(c.legendGroup);this.legendItemWidth=b+a+(q?e:d);this.legendItemHeight=f+a+(q?d:0)},setState:function(h){this.series.forEach(function(c){c.setState(h)})},
visible:!0,setVisible:u,getSeriesExtremes:function(){var h=this.series,c=h.length,a;this.dataMin=Infinity;for(this.dataMax=-Infinity;c--;){var e=h[c];var b=e.colorKey=n(e.options.colorKey,e.colorKey,e.pointValKey,e.zoneAxis,"y");var f=e.pointArrayMap;var d=e[b+"Min"]&&e[b+"Max"];if(e[b+"Data"])var l=e[b+"Data"];else if(f){l=[];f=f.indexOf(b);var k=e.yData;if(0<=f&&k)for(a=0;a<k.length;a++)l.push(n(k[a][f],k[a]))}else l=e.yData;d?(e.minColorValue=e[b+"Min"],e.maxColorValue=e[b+"Max"]):(x.prototype.getExtremes.call(e,
l),e.minColorValue=e.dataMin,e.maxColorValue=e.dataMax);void 0!==e.minColorValue&&(this.dataMin=Math.min(this.dataMin,e.minColorValue),this.dataMax=Math.max(this.dataMax,e.maxColorValue));d||A.Series.prototype.getExtremes.call(e)}},drawCrosshair:function(h,c){var e=c&&c.plotX,a=c&&c.plotY,b=this.pos,q=this.len;if(c){var n=this.toPixels(c[c.series.colorKey]);n<b?n=b-2:n>b+q&&(n=b+q+2);c.plotX=n;c.plotY=this.len-n;d.prototype.drawCrosshair.call(this,h,c);c.plotX=e;c.plotY=a;this.cross&&!this.cross.addedToColorAxis&&
this.legendGroup&&(this.cross.addClass("highcharts-coloraxis-marker").add(this.legendGroup),this.cross.addedToColorAxis=!0,this.chart.styledMode||this.cross.attr({fill:this.crosshair.color}))}},getPlotLinePath:function(c){var h=c.translatedValue;return p(h)?this.horiz?["M",h-4,this.top-6,"L",h+4,this.top-6,h,this.top,"Z"]:["M",this.left,h,"L",this.left-6,h+6,this.left-6,h-6,"Z"]:d.prototype.getPlotLinePath.apply(this,arguments)},update:function(c,a){var h=this.chart,b=h.legend,q=this.buildOptions.call(h,
{},c);this.series.forEach(function(c){c.isDirtyData=!0});(c.dataClasses&&b.allItems||this.dataClasses)&&this.destroyItems();h.options[this.coll]=e(this.userOptions,q);d.prototype.update.call(this,q,a);this.legendItem&&(this.setLegendColor(),b.colorizeItem(this,!0))},destroyItems:function(){var c=this.chart;this.legendItem?c.legend.destroyItem(this):this.legendItems&&this.legendItems.forEach(function(h){c.legend.destroyItem(h)});c.isDirtyLegend=!0},remove:function(c){this.destroyItems();d.prototype.remove.call(this,
c)},getDataClassLegendSymbols:function(){var c=this,e=this.chart,n=this.legendItems,f=e.options.legend,d=f.valueDecimals,l=f.valueSuffix||"",k;n.length||this.dataClasses.forEach(function(h,q){var f=!0,C=h.from,D=h.to;k="";void 0===C?k="< ":void 0===D&&(k="> ");void 0!==C&&(k+=a.numberFormat(C,d)+l);void 0!==C&&void 0!==D&&(k+=" - ");void 0!==D&&(k+=a.numberFormat(D,d)+l);n.push(b({chart:e,name:k,options:{},drawLegendSymbol:v.drawRectangle,visible:!0,setState:u,isDataClass:!0,setVisible:function(){f=
this.visible=!f;c.series.forEach(function(c){c.points.forEach(function(c){c.dataClass===q&&c.setVisible(f)})});e.legend.colorizeItem(this,f)}},h))});return n},beforePadding:!1,name:""});["fill","stroke"].forEach(function(c){a.Fx.prototype[c+"Setter"]=function(){this.elem.attr(c,f(this.start).tweenTo(f(this.end),this.pos),null,!0)}});g(m,"afterGetAxes",function(){var h=this,e=h.options;this.colorAxis=[];e.colorAxis&&(e.colorAxis=w(e.colorAxis),e.colorAxis.forEach(function(e,a){e.index=a;new c(h,e)}))});
g(x,"bindAxes",function(){var c=this.axisTypes;c?-1===c.indexOf("colorAxis")&&c.push("colorAxis"):this.axisTypes=["colorAxis"]});g(l,"afterGetAllItems",function(c){var h=[],e,a;(this.chart.colorAxis||[]).forEach(function(a){(e=a.options)&&e.showInLegend&&(e.dataClasses&&e.visible?h=h.concat(a.getDataClassLegendSymbols()):e.visible&&h.push(a),a.series.forEach(function(h){if(!h.options.showInLegend||e.dataClasses)"point"===h.options.legendType?h.points.forEach(function(h){t(c.allItems,h)}):t(c.allItems,
h)}))});for(a=h.length;a--;)c.allItems.unshift(h[a])});g(l,"afterColorizeItem",function(c){c.visible&&c.item.legendColor&&c.item.legendSymbol.attr({fill:c.item.legendColor})});g(l,"afterUpdate",function(){var c=this.chart.colorAxis;c&&c.forEach(function(c,e,h){c.update({},h)})});g(x,"afterTranslate",function(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()})});z(m,"parts-map/ColorMapSeriesMixin.js",[m["parts/Globals.js"],m["parts/Utilities.js"]],function(a,
g){var t=g.defined;g=a.noop;var p=a.seriesTypes;a.colorMapPointMixin={dataLabelOnNull:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value},setState:function(g){a.Point.prototype.setState.call(this,g);this.graphic&&this.graphic.attr({zIndex:"hover"===g?1:0})}};a.colorMapSeriesMixin={pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:g,parallelArrays:["x","y","value"],colorKey:"value",
pointAttribs:p.column.prototype.pointAttribs,colorAttribs:function(a){var d={};t(a.color)&&(d[this.colorProp||"fill"]=a.color);return d}}});z(m,"parts-map/MapNavigation.js",[m["parts/Globals.js"],m["parts/Utilities.js"]],function(a,g){function t(a){a&&(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function p(a){this.init(a)}var w=g.objectEach,d=a.addEvent;g=a.Chart;var m=a.doc,x=a.extend,r=a.merge,f=a.pick;p.prototype.init=function(a){this.chart=a;
a.mapNavButtons=[]};p.prototype.update=function(a){var b=this.chart,g=b.options.mapNavigation,k,u,e,n,c,h=function(c){this.handler.call(b,c);t(c)},q=b.mapNavButtons;a&&(g=b.options.mapNavigation=r(b.options.mapNavigation,a));for(;q.length;)q.pop().destroy();f(g.enableButtons,g.enabled)&&!b.renderer.forExport&&w(g.buttons,function(a,f){k=r(g.buttonOptions,a);b.styledMode||(u=k.theme,u.style=r(k.theme.style,k.style),n=(e=u.states)&&e.hover,c=e&&e.select);a=b.renderer.button(k.text,0,0,h,u,n,c,0,"zoomIn"===
f?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[f]).attr({width:k.width,height:k.height,title:b.options.lang[f],padding:k.padding,zIndex:5}).add();a.handler=k.onclick;a.align(x(k,{width:a.width,height:2*a.height}),null,k.alignTo);d(a.element,"dblclick",t);q.push(a)});this.updateEvents(g)};p.prototype.updateEvents=function(a){var b=this.chart;f(a.enableDoubleClickZoom,a.enabled)||a.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||
d(b.container,"dblclick",function(a){b.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());f(a.enableMouseWheelZoom,a.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||d(b.container,void 0===m.onmousewheel?"DOMMouseScroll":"mousewheel",function(a){b.pointer.onContainerMouseWheel(a);t(a);return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};x(g.prototype,{fitToBox:function(a,f){[["x","width"],["y","height"]].forEach(function(b){var d=
b[0];b=b[1];a[d]+a[b]>f[d]+f[b]&&(a[b]>f[b]?(a[b]=f[b],a[d]=f[d]):a[d]=f[d]+f[b]-a[b]);a[b]>f[b]&&(a[b]=f[b]);a[d]<f[d]&&(a[d]=f[d])});return a},mapZoom:function(a,d,g,k,u){var e=this.xAxis[0],b=e.max-e.min,c=f(d,e.min+b/2),h=b*a;b=this.yAxis[0];var q=b.max-b.min,C=f(g,b.min+q/2);q*=a;c=this.fitToBox({x:c-h*(k?(k-e.pos)/e.len:.5),y:C-q*(u?(u-b.pos)/b.len:.5),width:h,height:q},{x:e.dataMin,y:b.dataMin,width:e.dataMax-e.dataMin,height:b.dataMax-b.dataMin});h=c.x<=e.dataMin&&c.width>=e.dataMax-e.dataMin&&
c.y<=b.dataMin&&c.height>=b.dataMax-b.dataMin;k&&(e.fixTo=[k-e.pos,d]);u&&(b.fixTo=[u-b.pos,g]);void 0===a||h?(e.setExtremes(void 0,void 0,!1),b.setExtremes(void 0,void 0,!1)):(e.setExtremes(c.x,c.x+c.width,!1),b.setExtremes(c.y,c.y+c.height,!1));this.redraw()}});d(g,"beforeRender",function(){this.mapNavigation=new p(this);this.mapNavigation.update()});a.MapNavigation=p});z(m,"parts-map/MapPointer.js",[m["parts/Globals.js"]],function(a){var g=a.extend,t=a.pick,p=a.Pointer;a=a.wrap;g(p.prototype,{onContainerDblClick:function(a){var d=
this.chart;a=this.normalize(a);d.options.mapNavigation.enableDoubleClickZoomTo?d.pointer.inClass(a.target,"highcharts-tracker")&&d.hoverPoint&&d.hoverPoint.zoomTo():d.isInsidePlot(a.chartX-d.plotLeft,a.chartY-d.plotTop)&&d.mapZoom(.5,d.xAxis[0].toValue(a.chartX),d.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)},onContainerMouseWheel:function(a){var d=this.chart;a=this.normalize(a);var g=a.detail||-(a.wheelDelta/120);d.isInsidePlot(a.chartX-d.plotLeft,a.chartY-d.plotTop)&&d.mapZoom(Math.pow(d.options.mapNavigation.mouseWheelSensitivity,
g),d.xAxis[0].toValue(a.chartX),d.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)}});a(p.prototype,"zoomOption",function(a){var d=this.chart.options.mapNavigation;t(d.enableTouchZoom,d.enabled)&&(this.chart.options.chart.pinchType="xy");a.apply(this,[].slice.call(arguments,1))});a(p.prototype,"pinchTranslate",function(a,d,g,p,r,f,b){a.call(this,d,g,p,r,f,b);"map"===this.chart.options.chart.type&&this.hasZoom&&(a=p.scaleX>p.scaleY,this.pinchTranslateDirection(!a,d,g,p,r,f,b,a?p.scaleX:p.scaleY))})});
z(m,"parts-map/MapSeries.js",[m["parts/Globals.js"],m["parts/Utilities.js"]],function(a,g){var t=g.isArray,p=g.isNumber,m=g.objectEach,d=g.splat;g=a.colorMapPointMixin;var y=a.extend,x=a.merge,r=a.noop,f=a.pick,b=a.fireEvent,l=a.Point,v=a.Series,k=a.seriesType,u=a.seriesTypes;k("map","scatter",{animation:!1,dataLabels:{crop:!1,formatter:function(){return this.point.value},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,
pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#cccccc",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:"#cccccc"},inactive:{opacity:1}}},x(a.colorMapSeriesMixin,{type:"map",getExtremesFromAll:!0,useMapGeometry:!0,forceDL:!0,searchPoint:r,directTouch:!0,preserveAspectRatio:!0,pointArrayMap:["value"],setOptions:function(a){a=v.prototype.setOptions.call(this,a);var e=a.joinBy;null===e&&(e="_i");e=this.joinBy=
d(e);e[1]||(e[1]=e[0]);return a},getBox:function(e){var b=Number.MAX_VALUE,c=-b,h=b,q=-b,d=b,k=b,g=this.xAxis,B=this.yAxis,u;(e||[]).forEach(function(e){if(e.path){"string"===typeof e.path&&(e.path=a.splitPath(e.path));var n=e.path||[],C=n.length,g=!1,B=-b,D=b,r=-b,l=b,E=e.properties;if(!e._foundBox){for(;C--;)p(n[C])&&(g?(B=Math.max(B,n[C]),D=Math.min(D,n[C])):(r=Math.max(r,n[C]),l=Math.min(l,n[C])),g=!g);e._midX=D+(B-D)*f(e.middleX,E&&E["hc-middle-x"],.5);e._midY=l+(r-l)*f(e.middleY,E&&E["hc-middle-y"],
.5);e._maxX=B;e._minX=D;e._maxY=r;e._minY=l;e.labelrank=f(e.labelrank,(B-D)*(r-l));e._foundBox=!0}c=Math.max(c,e._maxX);h=Math.min(h,e._minX);q=Math.max(q,e._maxY);d=Math.min(d,e._minY);k=Math.min(e._maxX-e._minX,e._maxY-e._minY,k);u=!0}});u&&(this.minY=Math.min(d,f(this.minY,b)),this.maxY=Math.max(q,f(this.maxY,-b)),this.minX=Math.min(h,f(this.minX,b)),this.maxX=Math.max(c,f(this.maxX,-b)),g&&void 0===g.options.minRange&&(g.minRange=Math.min(5*k,(this.maxX-this.minX)/5,g.minRange||b)),B&&void 0===
B.options.minRange&&(B.minRange=Math.min(5*k,(this.maxY-this.minY)/5,B.minRange||b)))},hasData:function(){return!!this.processedXData.length},getExtremes:function(){v.prototype.getExtremes.call(this,this.valueData);this.chart.hasRendered&&this.isDirtyData&&this.getBox(this.options.data);this.valueMin=this.dataMin;this.valueMax=this.dataMax;this.dataMin=this.minY;this.dataMax=this.maxY},translatePath:function(a){var e=!1,c=this.xAxis,h=this.yAxis,b=c.min,f=c.transA;c=c.minPixelPadding;var d=h.min,
g=h.transA;h=h.minPixelPadding;var k,l=[];if(a)for(k=a.length;k--;)p(a[k])?(l[k]=e?(a[k]-b)*f+c:(a[k]-d)*g+h,e=!e):l[k]=a[k];return l},setData:function(e,b,c,h){var f=this.options,d=this.chart.options.chart,n=d&&d.map,k=f.mapData,g=this.joinBy,l=f.keys||this.pointArrayMap,u=[],r={},w=this.chart.mapTransforms;!k&&n&&(k="string"===typeof n?a.maps[n]:n);e&&e.forEach(function(c,h){var b=0;if(p(c))e[h]={value:c};else if(t(c)){e[h]={};!f.keys&&c.length>l.length&&"string"===typeof c[0]&&(e[h]["hc-key"]=
c[0],++b);for(var q=0;q<l.length;++q,++b)l[q]&&void 0!==c[b]&&(0<l[q].indexOf(".")?a.Point.prototype.setNestedProperty(e[h],c[b],l[q]):e[h][l[q]]=c[b])}g&&"_i"===g[0]&&(e[h]._i=h)});this.getBox(e);(this.chart.mapTransforms=w=d&&d.mapTransforms||k&&k["hc-transform"]||w)&&m(w,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(k){"FeatureCollection"===k.type&&(this.mapTitle=k.title,k=a.geojson(k,this.type,this));this.mapData=k;this.mapMap={};for(w=0;w<k.length;w++)d=
k[w],n=d.properties,d._i=w,g[0]&&n&&n[g[0]]&&(d[g[0]]=n[g[0]]),r[d[g[0]]]=d;this.mapMap=r;e&&g[1]&&e.forEach(function(a){r[a[g[1]]]&&u.push(r[a[g[1]]])});f.allAreas?(this.getBox(k),e=e||[],g[1]&&e.forEach(function(a){u.push(a[g[1]])}),u="|"+u.map(function(a){return a&&a[g[0]]}).join("|")+"|",k.forEach(function(a){g[0]&&-1!==u.indexOf("|"+a[g[0]]+"|")||(e.push(x(a,{value:null})),h=!1)})):this.getBox(u)}v.prototype.setData.call(this,e,b,c,h)},drawGraph:r,drawDataLabels:r,doFullTranslate:function(){return this.isDirtyData||
this.chart.isResizing||this.chart.renderer.isVML||!this.baseTrans},translate:function(){var a=this,f=a.xAxis,c=a.yAxis,h=a.doFullTranslate();a.generatePoints();a.data.forEach(function(e){p(e._midX)&&p(e._midY)&&(e.plotX=f.toPixels(e._midX,!0),e.plotY=c.toPixels(e._midY,!0));h&&(e.shapeType="path",e.shapeArgs={d:a.translatePath(e.path)})});b(a,"afterTranslate")},pointAttribs:function(a,b){b=a.series.chart.styledMode?this.colorAttribs(a):u.column.prototype.pointAttribs.call(this,a,b);b["stroke-width"]=
f(a.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||"borderWidth"],"inherit");return b},drawPoints:function(){var a=this,b=a.xAxis,c=a.yAxis,h=a.group,d=a.chart,k=d.renderer,g=this.baseTrans;a.transformGroup||(a.transformGroup=k.g().attr({scaleX:1,scaleY:1}).add(h),a.transformGroup.survive=!0);if(a.doFullTranslate())d.hasRendered&&!d.styledMode&&a.points.forEach(function(c){c.shapeArgs&&(c.shapeArgs.fill=a.pointAttribs(c,c.state).fill)}),a.group=a.transformGroup,u.column.prototype.drawPoints.apply(a),
a.group=h,a.points.forEach(function(c){if(c.graphic){var h="";c.name&&(h+="highcharts-name-"+c.name.replace(/ /g,"-").toLowerCase());c.properties&&c.properties["hc-key"]&&(h+=" highcharts-key-"+c.properties["hc-key"].toLowerCase());h&&c.graphic.addClass(h);d.styledMode&&c.graphic.css(a.pointAttribs(c,c.selected&&"select"))}}),this.baseTrans={originX:b.min-b.minPixelPadding/b.transA,originY:c.min-c.minPixelPadding/c.transA+(c.reversed?0:c.len/c.transA),transAX:b.transA,transAY:c.transA},this.transformGroup.animate({translateX:0,
translateY:0,scaleX:1,scaleY:1});else{var l=b.transA/g.transAX;var r=c.transA/g.transAY;var p=b.toPixels(g.originX,!0);var t=c.toPixels(g.originY,!0);.99<l&&1.01>l&&.99<r&&1.01>r&&(r=l=1,p=Math.round(p),t=Math.round(t));var v=this.transformGroup;if(d.renderer.globalAnimation){var w=v.attr("translateX");var m=v.attr("translateY");var y=v.attr("scaleX");var x=v.attr("scaleY");v.attr({animator:0}).animate({animator:1},{step:function(a,c){v.attr({translateX:w+(p-w)*c.pos,translateY:m+(t-m)*c.pos,scaleX:y+
(l-y)*c.pos,scaleY:x+(r-x)*c.pos})}})}else v.attr({translateX:p,translateY:t,scaleX:l,scaleY:r})}d.styledMode||h.element.setAttribute("stroke-width",f(a.options[a.pointAttrToOptions&&a.pointAttrToOptions["stroke-width"]||"borderWidth"],1)/(l||1));this.drawMapDataLabels()},drawMapDataLabels:function(){v.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)},render:function(){var a=this,b=v.prototype.render;a.chart.renderer.isVML&&3E3<a.data.length?
setTimeout(function(){b.call(a)}):b.call(a)},animate:function(a){var e=this.options.animation,c=this.group,h=this.xAxis,b=this.yAxis,f=h.pos,d=b.pos;this.chart.renderer.isSVG&&(!0===e&&(e={duration:1E3}),a?c.attr({translateX:f+h.len/2,translateY:d+b.len/2,scaleX:.001,scaleY:.001}):(c.animate({translateX:f,translateY:d,scaleX:1,scaleY:1},e),this.animate=null))},animateDrilldown:function(a){var e=this.chart.plotBox,c=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],h=c.bBox,b=this.chart.options.drilldown.animation;
a||(a=Math.min(h.width/e.width,h.height/e.height),c.shapeArgs={scaleX:a,scaleY:a,translateX:h.x,translateY:h.y},this.points.forEach(function(a){a.graphic&&a.graphic.attr(c.shapeArgs).animate({scaleX:1,scaleY:1,translateX:0,translateY:0},b)}),this.animate=null)},drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,animateDrillupFrom:function(a){u.column.prototype.animateDrillupFrom.call(this,a)},animateDrillupTo:function(a){u.column.prototype.animateDrillupTo.call(this,a)}}),y({applyOptions:function(a,
b){var c=this.series;a=l.prototype.applyOptions.call(this,a,b);b=c.joinBy;c.mapData&&((b=void 0!==a[b[1]]&&c.mapMap[a[b[1]]])?(c.xyFromShape&&(a.x=b._midX,a.y=b._midY),y(a,b)):a.value=a.value||null);return a},onMouseOver:function(b){a.clearTimeout(this.colorInterval);if(null!==this.value||this.series.options.nullInteraction)l.prototype.onMouseOver.call(this,b);else this.series.onMouseOut(b)},zoomTo:function(){var a=this.series;a.xAxis.setExtremes(this._minX,this._maxX,!1);a.yAxis.setExtremes(this._minY,
this._maxY,!1);a.chart.redraw()}},g));""});z(m,"parts-map/MapLineSeries.js",[m["parts/Globals.js"]],function(a){var g=a.seriesType,t=a.seriesTypes;g("mapline","map",{lineWidth:1,fillColor:"none"},{type:"mapline",colorProp:"stroke",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointAttribs:function(a,g){a=t.map.prototype.pointAttribs.call(this,a,g);a.fill=this.options.fillColor;return a},drawLegendSymbol:t.line.prototype.drawLegendSymbol});""});z(m,"parts-map/MapPointSeries.js",[m["parts/Globals.js"]],
function(a){var g=a.merge,t=a.Point;a=a.seriesType;a("mappoint","scatter",{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}},{type:"mappoint",forceDL:!0},{applyOptions:function(a,m){a=void 0!==a.lat&&void 0!==a.lon?g(a,this.series.chart.fromLatLonToPoint(a)):a;return t.prototype.applyOptions.call(this,a,m)}});""});z(m,"parts-more/BubbleLegend.js",[m["parts/Globals.js"],m["parts/Utilities.js"]],function(a,g){var t=g.isNumber,
p=g.objectEach;g=a.Series;var m=a.Legend,d=a.Chart,y=a.addEvent,x=a.wrap,r=a.color,f=a.numberFormat,b=a.merge,l=a.noop,v=a.pick,k=a.stableSort,u=a.setOptions,e=a.arrayMin,n=a.arrayMax;u({legend:{bubbleLegend:{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:10,color:void 0},x:0,y:0},maxSize:60,
minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}});a.BubbleLegend=function(a,h){this.init(a,h)};a.BubbleLegend.prototype={init:function(a,h){this.options=a;this.visible=!0;this.chart=h.chart;this.legend=h},setState:l,addToLegend:function(a){a.splice(this.options.legendIndex,0,this)},drawLegendSymbol:function(a){var c=this.chart,b=this.options,e=v(a.options.itemDistance,20),f=b.ranges;var d=
b.connectorDistance;this.fontMetrics=c.renderer.fontMetrics(b.labels.style.fontSize.toString()+"px");f&&f.length&&t(f[0].value)?(k(f,function(a,c){return c.value-a.value}),this.ranges=f,this.setOptions(),this.render(),c=this.getMaxLabelSize(),f=this.ranges[0].radius,a=2*f,d=d-f+c.width,d=0<d?d:0,this.maxLabel=c,this.movementX="left"===b.labels.align?d:0,this.legendItemWidth=a+d+e,this.legendItemHeight=a+this.fontMetrics.h/2):a.options.bubbleLegend.autoRanges=!0},setOptions:function(){var a=this.ranges,
h=this.options,e=this.chart.series[h.seriesIndex],f=this.legend.baseline,d={"z-index":h.zIndex,"stroke-width":h.borderWidth},g={"z-index":h.zIndex,"stroke-width":h.connectorWidth},k=this.getLabelStyles(),l=e.options.marker.fillOpacity,n=this.chart.styledMode;a.forEach(function(c,q){n||(d.stroke=v(c.borderColor,h.borderColor,e.color),d.fill=v(c.color,h.color,1!==l?r(e.color).setOpacity(l).get("rgba"):e.color),g.stroke=v(c.connectorColor,h.connectorColor,e.color));a[q].radius=this.getRangeRadius(c.value);
a[q]=b(a[q],{center:a[0].radius-a[q].radius+f});n||b(!0,a[q],{bubbleStyle:b(!1,d),connectorStyle:b(!1,g),labelStyle:k})},this)},getLabelStyles:function(){var a=this.options,h={},e="left"===a.labels.align,f=this.legend.options.rtl;p(a.labels.style,function(a,c){"color"!==c&&"fontSize"!==c&&"z-index"!==c&&(h[c]=a)});return b(!1,h,{"font-size":a.labels.style.fontSize,fill:v(a.labels.style.color,"#000000"),"z-index":a.zIndex,align:f||e?"right":"left"})},getRangeRadius:function(a){var c=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,
c.ranges[c.ranges.length-1].value,c.ranges[0].value,c.minSize,c.maxSize,a)},render:function(){var a=this.chart.renderer,b=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});this.legendSymbol=a.g("bubble-legend");this.legendItem=a.g("bubble-legend-item");this.legendSymbol.translateX=0;this.legendSymbol.translateY=0;this.ranges.forEach(function(a){a.value>=b&&this.renderRange(a)},this);this.legendSymbol.add(this.legendItem);this.legendItem.add(this.legendGroup);
this.hideOverlappingLabels()},renderRange:function(a){var c=this.options,b=c.labels,e=this.chart.renderer,f=this.symbols,d=f.labels,g=a.center,k=Math.abs(a.radius),l=c.connectorDistance,n=b.align,r=b.style.fontSize;l=this.legend.options.rtl||"left"===n?-l:l;b=c.connectorWidth;var u=this.ranges[0].radius,p=g-k-c.borderWidth/2+b/2;r=r/2-(this.fontMetrics.h-r)/2;var t=e.styledMode;"center"===n&&(l=0,c.connectorDistance=0,a.labelStyle.align="center");n=p+c.labels.y;var v=u+l+c.labels.x;f.bubbleItems.push(e.circle(u,
g+((p%1?1:.5)-(b%2?0:.5)),k).attr(t?{}:a.bubbleStyle).addClass((t?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-symbol "+(c.className||"")).add(this.legendSymbol));f.connectors.push(e.path(e.crispLine(["M",u,p,"L",u+l,p],c.connectorWidth)).attr(t?{}:a.connectorStyle).addClass((t?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(c.connectorClassName||"")).add(this.legendSymbol));a=e.text(this.formatLabel(a),v,n+r).attr(t?{}:
a.labelStyle).addClass("highcharts-bubble-legend-labels "+(c.labels.className||"")).add(this.legendSymbol);d.push(a);a.placed=!0;a.alignAttr={x:v,y:n+r}},getMaxLabelSize:function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}},formatLabel:function(c){var b=this.options,e=b.labels.formatter;return(b=b.labels.format)?a.format(b,c):e?e.call(c):f(c.value,1)},hideOverlappingLabels:function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&
b&&(a.hideOverlappingLabels(b.labels),b.labels.forEach(function(a,c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))},getRanges:function(){var a=this.legend.bubbleLegend,h=a.options.ranges,f,d=Number.MAX_VALUE,g=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(f=a.zData.filter(t),f.length&&(d=v(a.options.zMin,Math.min(d,Math.max(e(f),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),g=v(a.options.zMax,
Math.max(g,n(f)))))});var k=d===g?[{value:g}]:[{value:d},{value:(d+g)/2},{value:g,autoRanges:!0}];h.length&&h[0].radius&&k.reverse();k.forEach(function(a,c){h&&h[c]&&(k[c]=b(!1,h[c],a))});return k},predictBubbleSizes:function(){var a=this.chart,b=this.fontMetrics,e=a.legend.options,f="horizontal"===e.layout,d=f?a.legend.lastLineHeight:0,g=a.plotSizeX,k=a.plotSizeY,l=a.series[this.options.seriesIndex];a=Math.ceil(l.minPxSize);var n=Math.ceil(l.maxPxSize);l=l.options.maxSize;var r=Math.min(k,g);if(e.floating||
!/%$/.test(l))b=n;else if(l=parseFloat(l),b=(r+d-b.h/2)*l/100/(l/100+1),f&&k-b>=g||!f&&g-b>=k)b=n;return[a,Math.ceil(b)]},updateRanges:function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=this.getRanges()},correctSizes:function(){var a=this.legend,b=this.chart.series[this.options.seriesIndex];1<Math.abs(Math.ceil(b.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())}};y(a.Legend,"afterGetAllItems",function(c){var b=this.bubbleLegend,
e=this.options,f=e.bubbleLegend,d=this.chart.getVisibleBubbleSeriesIndex();b&&b.ranges&&b.ranges.length&&(f.ranges.length&&(f.autoRanges=!!f.ranges[0].autoRanges),this.destroyItem(b));0<=d&&e.enabled&&f.enabled&&(f.seriesIndex=d,this.bubbleLegend=new a.BubbleLegend(f,this),this.bubbleLegend.addToLegend(c.allItems))});d.prototype.getVisibleBubbleSeriesIndex=function(){for(var a=this.series,b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;b++}return-1};m.prototype.getLinesHeights=
function(){var a=this.allItems,b=[],e=a.length,f,d=0;for(f=0;f<e;f++)if(a[f].legendItemHeight&&(a[f].itemHeight=a[f].legendItemHeight),a[f]===a[e-1]||a[f+1]&&a[f]._legendItemPos[1]!==a[f+1]._legendItemPos[1]){b.push({height:0});var g=b[b.length-1];for(d;d<=f;d++)a[d].itemHeight>g.height&&(g.height=a[d].itemHeight);g.step=f}return b};m.prototype.retranslateItems=function(a){var b,c,e,f=this.options.rtl,d=0;this.allItems.forEach(function(h,g){b=h.legendGroup.translateX;c=h._legendItemPos[1];if((e=h.movementX)||
f&&h.ranges)e=f?b-h.options.maxSize/2:b+e,h.legendGroup.attr({translateX:e});g>a[d].step&&d++;h.legendGroup.attr({translateY:Math.round(c+a[d].height/2)});h._legendItemPos[1]=c+a[d].height/2})};y(g,"legendItemClick",function(){var a=this.chart,b=this.visible,e=this.chart.legend;e&&e.bubbleLegend&&(this.visible=!b,this.ignoreSeries=b,a=0<=a.getVisibleBubbleSeriesIndex(),e.bubbleLegend.visible!==a&&(e.update({bubbleLegend:{enabled:a}}),e.bubbleLegend.visible=a),this.visible=b)});x(d.prototype,"drawChartBox",
function(a,b,e){var c=this.legend,f=0<=this.getVisibleBubbleSeriesIndex();if(c&&c.options.enabled&&c.bubbleLegend&&c.options.bubbleLegend.autoRanges&&f){var h=c.bubbleLegend.options;f=c.bubbleLegend.predictBubbleSizes();c.bubbleLegend.updateRanges(f[0],f[1]);h.placed||(c.group.placed=!1,c.allItems.forEach(function(a){a.legendGroup.translateY=null}));c.render();this.getMargins();this.axes.forEach(function(a){a.visible&&a.render();h.placed||(a.setScale(),a.updateNames(),p(a.ticks,function(a){a.isNew=
!0;a.isNewLabel=!0}))});h.placed=!0;this.getMargins();a.call(this,b,e);c.bubbleLegend.correctSizes();c.retranslateItems(c.getLinesHeights())}else a.call(this,b,e),c&&c.options.enabled&&c.bubbleLegend&&(c.render(),c.retranslateItems(c.getLinesHeights()))})});z(m,"parts-more/BubbleSeries.js",[m["parts/Globals.js"],m["parts/Utilities.js"]],function(a,g){var t=g.isNumber,p=g.pInt,m=a.arrayMax,d=a.arrayMin;g=a.Axis;var y=a.color,x=a.noop,r=a.pick,f=a.Point,b=a.Series,l=a.seriesType,v=a.seriesTypes;l("bubble",
"scatter",{dataLabels:{formatter:function(){return this.point.z},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"},{pointArrayMap:["y","z"],parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],
specialGroup:"group",bubblePadding:!0,zoneAxis:"z",directTouch:!0,isBubble:!0,pointAttribs:function(a,f){var e=this.options.marker.fillOpacity;a=b.prototype.pointAttribs.call(this,a,f);1!==e&&(a.fill=y(a.fill).setOpacity(e).get("rgba"));return a},getRadii:function(a,b,e){var f=this.zData,c=this.yData,h=e.minPxSize,d=e.maxPxSize,g=[];var k=0;for(e=f.length;k<e;k++){var l=f[k];g.push(this.getRadius(a,b,h,d,l,c[k]))}this.radii=g},getRadius:function(a,b,e,f,c,h){var d=this.options,g="width"!==d.sizeBy,
k=d.zThreshold,l=b-a,n=.5;if(null===h||null===c)return null;if(t(c)){d.sizeByAbsoluteValue&&(c=Math.abs(c-k),l=Math.max(b-k,Math.abs(a-k)),a=0);if(c<a)return e/2-1;0<l&&(n=(c-a)/l)}g&&0<=n&&(n=Math.sqrt(n));return Math.ceil(e+n*(f-e))/2},animate:function(a){!a&&this.points.length<this.options.animationLimit&&(this.points.forEach(function(a){var b=a.graphic;if(b&&b.width){var f={x:b.x,y:b.y,width:b.width,height:b.height};b.attr({x:a.plotX,y:a.plotY,width:1,height:1});b.animate(f,this.options.animation)}},
this),this.animate=null)},hasData:function(){return!!this.processedXData.length},translate:function(){var b,f=this.data,e=this.radii;v.scatter.prototype.translate.call(this);for(b=f.length;b--;){var d=f[b];var c=e?e[b]:0;t(c)&&c>=this.minPxSize/2?(d.marker=a.extend(d.marker,{radius:c,width:2*c,height:2*c}),d.dlBox={x:d.plotX-c,y:d.plotY-c,width:2*c,height:2*c}):d.shapeArgs=d.plotY=d.dlBox=void 0}},alignDataLabel:v.column.prototype.alignDataLabel,buildKDTree:x,applyZones:x},{haloPath:function(a){return f.prototype.haloPath.call(this,
0===a?0:(this.marker?this.marker.radius||0:0)+a)},ttBelow:!1});g.prototype.beforePadding=function(){var a=this,b=this.len,e=this.chart,f=0,c=b,h=this.isXAxis,g=h?"xData":"yData",l=this.min,v={},w=Math.min(e.plotWidth,e.plotHeight),y=Number.MAX_VALUE,x=-Number.MAX_VALUE,z=this.max-l,A=b/z,F=[];this.series.forEach(function(b){var c=b.options;!b.bubblePadding||!b.visible&&e.options.chart.ignoreHiddenSeries||(a.allowZoomOutside=!0,F.push(b),h&&(["minSize","maxSize"].forEach(function(a){var b=c[a],e=/%$/.test(b);
b=p(b);v[a]=e?w*b/100:b}),b.minPxSize=v.minSize,b.maxPxSize=Math.max(v.maxSize,v.minSize),b=b.zData.filter(t),b.length&&(y=r(c.zMin,Math.min(y,Math.max(d(b),!1===c.displayNegative?c.zThreshold:-Number.MAX_VALUE))),x=r(c.zMax,Math.max(x,m(b))))))});F.forEach(function(b){var e=b[g],d=e.length;h&&b.getRadii(y,x,b);if(0<z)for(;d--;)if(t(e[d])&&a.dataMin<=e[d]&&e[d]<=a.dataMax){var k=b.radii?b.radii[d]:0;f=Math.min((e[d]-l)*A-k,f);c=Math.max((e[d]-l)*A+k,c)}});F.length&&0<z&&!this.isLog&&(c-=b,A*=(b+Math.max(0,
f)-Math.min(c,b))/b,[["min","userMin",f],["max","userMax",c]].forEach(function(b){void 0===r(a.options[b[0]],a[b[1]])&&(a[b[0]]+=b[2]/A)}))};""});z(m,"parts-map/MapBubbleSeries.js",[m["parts/Globals.js"]],function(a){var g=a.merge,t=a.Point,p=a.seriesType,m=a.seriesTypes;m.bubble&&p("mapbubble","bubble",{animationLimit:500,tooltip:{pointFormat:"{point.name}: {point.z}"}},{xyFromShape:!0,type:"mapbubble",pointArrayMap:["z"],getMapData:m.map.prototype.getMapData,getBox:m.map.prototype.getBox,setData:m.map.prototype.setData,
setOptions:m.map.prototype.setOptions},{applyOptions:function(a,p){return a&&void 0!==a.lat&&void 0!==a.lon?t.prototype.applyOptions.call(this,g(a,this.series.chart.fromLatLonToPoint(a)),p):m.map.prototype.pointClass.prototype.applyOptions.call(this,a,p)},isValid:function(){return"number"===typeof this.z},ttBelow:!1});""});z(m,"parts-map/HeatmapSeries.js",[m["parts/Globals.js"]],function(a){var g=a.colorMapPointMixin,t=a.merge,p=a.noop,m=a.pick,d=a.fireEvent,y=a.Series,x=a.seriesType,r=a.seriesTypes;
x("heatmap","scatter",{animation:!1,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){return this.point.value},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:null,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}},t(a.colorMapSeriesMixin,{pointArrayMap:["y","value"],hasPointSpecificOptions:!0,getExtremesFromAll:!0,directTouch:!0,init:function(){r.scatter.prototype.init.apply(this,arguments);
var a=this.options;a.pointRange=m(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||1},translate:function(){var a=this.options,b=this.xAxis,g=this.yAxis,r=a.pointPadding||0,k=function(a,b,c){return Math.min(Math.max(b,a),c)},u=this.pointPlacementToXValue();this.generatePoints();this.points.forEach(function(e){var f=(a.colsize||1)/2,c=(a.rowsize||1)/2,d=k(Math.round(b.len-b.translate(e.x-f,0,1,0,1,-u)),-b.len,2*b.len);f=k(Math.round(b.len-b.translate(e.x+f,0,1,0,1,-u)),-b.len,2*b.len);
var l=k(Math.round(g.translate(e.y-c,0,1,0,1)),-g.len,2*g.len);c=k(Math.round(g.translate(e.y+c,0,1,0,1)),-g.len,2*g.len);var p=m(e.pointPadding,r);e.plotX=e.clientX=(d+f)/2;e.plotY=(l+c)/2;e.shapeType="rect";e.shapeArgs={x:Math.min(d,f)+p,y:Math.min(l,c)+p,width:Math.max(Math.abs(f-d)-2*p,0),height:Math.max(Math.abs(c-l)-2*p,0)}});d(this,"afterTranslate")},drawPoints:function(){var a=this.chart.styledMode?"css":"animate";r.column.prototype.drawPoints.call(this);this.points.forEach(function(b){b.graphic[a](this.colorAttribs(b))},
this)},hasData:function(){return!!this.processedXData.length},getValidPoints:function(a,b){return y.prototype.getValidPoints.call(this,a,b,!0)},animate:p,getBox:p,drawLegendSymbol:a.LegendSymbolMixin.drawRectangle,alignDataLabel:r.column.prototype.alignDataLabel,getExtremes:function(){y.prototype.getExtremes.call(this,this.valueData);this.valueMin=this.dataMin;this.valueMax=this.dataMax;y.prototype.getExtremes.call(this)}}),a.extend({haloPath:function(a){if(!a)return[];var b=this.shapeArgs;return["M",
b.x-a,b.y-a,"L",b.x-a,b.y+b.height+a,b.x+b.width+a,b.y+b.height+a,b.x+b.width+a,b.y-a,"Z"]}},g));""});z(m,"parts-map/GeoJSON.js",[m["parts/Globals.js"]],function(a){function g(a,f){var b,d=!1,g=a.x,k=a.y;a=0;for(b=f.length-1;a<f.length;b=a++){var r=f[a][1]>k;var e=f[b][1]>k;r!==e&&g<(f[b][0]-f[a][0])*(k-f[a][1])/(f[b][1]-f[a][1])+f[a][0]&&(d=!d)}return d}var m=a.Chart,p=a.extend,w=a.format,d=a.merge,y=a.win,x=a.wrap;m.prototype.transformFromLatLon=function(d,f){if(void 0===y.proj4)return a.error(21,
!1,this),{x:0,y:null};d=y.proj4(f.crs,[d.lon,d.lat]);var b=f.cosAngle||f.rotation&&Math.cos(f.rotation),g=f.sinAngle||f.rotation&&Math.sin(f.rotation);d=f.rotation?[d[0]*b+d[1]*g,-d[0]*g+d[1]*b]:d;return{x:((d[0]-(f.xoffset||0))*(f.scale||1)+(f.xpan||0))*(f.jsonres||1)+(f.jsonmarginX||0),y:(((f.yoffset||0)-d[1])*(f.scale||1)+(f.ypan||0))*(f.jsonres||1)-(f.jsonmarginY||0)}};m.prototype.transformToLatLon=function(d,f){if(void 0===y.proj4)a.error(21,!1,this);else{d={x:((d.x-(f.jsonmarginX||0))/(f.jsonres||
1)-(f.xpan||0))/(f.scale||1)+(f.xoffset||0),y:((-d.y-(f.jsonmarginY||0))/(f.jsonres||1)+(f.ypan||0))/(f.scale||1)+(f.yoffset||0)};var b=f.cosAngle||f.rotation&&Math.cos(f.rotation),g=f.sinAngle||f.rotation&&Math.sin(f.rotation);f=y.proj4(f.crs,"WGS84",f.rotation?{x:d.x*b+d.y*-g,y:d.x*g+d.y*b}:d);return{lat:f.y,lon:f.x}}};m.prototype.fromPointToLatLon=function(d){var f=this.mapTransforms,b;if(f){for(b in f)if(Object.hasOwnProperty.call(f,b)&&f[b].hitZone&&g({x:d.x,y:-d.y},f[b].hitZone.coordinates[0]))return this.transformToLatLon(d,
f[b]);return this.transformToLatLon(d,f["default"])}a.error(22,!1,this)};m.prototype.fromLatLonToPoint=function(d){var f=this.mapTransforms,b;if(!f)return a.error(22,!1,this),{x:0,y:null};for(b in f)if(Object.hasOwnProperty.call(f,b)&&f[b].hitZone){var l=this.transformFromLatLon(d,f[b]);if(g({x:l.x,y:-l.y},f[b].hitZone.coordinates[0]))return l}return this.transformFromLatLon(d,f["default"])};a.geojson=function(a,d,b){var f=[],g=[],k=function(a){var b,d=a.length;g.push("M");for(b=0;b<d;b++)1===b&&
g.push("L"),g.push(a[b][0],-a[b][1])};d=d||"map";a.features.forEach(function(a){var b=a.geometry,l=b.type;b=b.coordinates;a=a.properties;var c;g=[];"map"===d||"mapbubble"===d?("Polygon"===l?(b.forEach(k),g.push("Z")):"MultiPolygon"===l&&(b.forEach(function(a){a.forEach(k)}),g.push("Z")),g.length&&(c={path:g})):"mapline"===d?("LineString"===l?k(b):"MultiLineString"===l&&b.forEach(k),g.length&&(c={path:g})):"mappoint"===d&&"Point"===l&&(c={x:b[0],y:-b[1]});c&&f.push(p(c,{name:a.name||a.NAME,properties:a}))});
b&&a.copyrightShort&&(b.chart.mapCredits=w(b.chart.options.credits.mapText,{geojson:a}),b.chart.mapCreditsFull=w(b.chart.options.credits.mapTextFull,{geojson:a}));return f};x(m.prototype,"addCredits",function(a,f){f=d(!0,this.options.credits,f);this.mapCredits&&(f.href=null);a.call(this,f);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})})});z(m,"parts-map/Map.js",[m["parts/Globals.js"]],function(a){function g(a,d,f,g,m,e,n,c){return["M",a+m,d,"L",a+f-e,d,"C",a+f-
e/2,d,a+f,d+e/2,a+f,d+e,"L",a+f,d+g-n,"C",a+f,d+g-n/2,a+f-n/2,d+g,a+f-n,d+g,"L",a+c,d+g,"C",a+c/2,d+g,a,d+g-c/2,a,d+g-c,"L",a,d+m,"C",a,d+m/2,a+m/2,d,a+m,d,"Z"]}var m=a.Chart,p=a.defaultOptions,w=a.extend,d=a.merge,y=a.pick,x=a.Renderer,r=a.SVGRenderer,f=a.VMLRenderer;w(p.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});p.mapNavigation={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},
buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};a.splitPath=function(a){var b;a=a.replace(/([A-Za-z])/g," $1 ");a=a.replace(/^\s*/,"").replace(/\s*$/,"");a=a.split(/[ ,]+/);for(b=0;b<a.length;b++)/[a-zA-Z]/.test(a[b])||(a[b]=parseFloat(a[b]));return a};a.maps={};r.prototype.symbols.topbutton=function(a,d,f,k,m){return g(a-1,d-1,f,k,m.r,m.r,0,0)};r.prototype.symbols.bottombutton=function(a,d,
f,k,m){return g(a-1,d-1,f,k,0,0,m.r,m.r)};x===f&&["topbutton","bottombutton"].forEach(function(a){f.prototype.symbols[a]=r.prototype.symbols[a]});a.Map=a.mapChart=function(b,f,g){var k="string"===typeof b||b.nodeName,l=arguments[k?1:0],e=l,n={endOnTick:!1,visible:!1,minPadding:0,maxPadding:0,startOnTick:!1},c=a.getOptions().credits;var h=l.series;l.series=null;l=d({chart:{panning:"xy",type:"map"},credits:{mapText:y(c.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),
mapTextFull:y(c.mapTextFull,"{geojson.copyright}")},tooltip:{followTouchMove:!1},xAxis:n,yAxis:d(n,{reversed:!0})},l,{chart:{inverted:!1,alignTicks:!1}});l.series=e.series=h;return k?new m(b,l,g):new m(l,f)}});z(m,"masters/modules/map.src.js",[],function(){})});
//# sourceMappingURL=map.js.map