@extends('layouts.master')

@section('content')

    @include('layouts.partial.notice')

    <div class="main-content-container container-fluid px-4">
        <!-- Page Header -->
        <div class="page-header row no-gutters py-4">
            <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
                <span class="text-uppercase page-subtitle">Overview</span>
                <h3 class="page-title"> Report {{ $pageData['pageName'] }}</h3>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Default Light Table -->

        <div class="col-8">
            <div class="card card-small mb-1">
            <div class="card-header border-bottom rounded">
                <h6 class="m-0 collapsed card-link w-100">
                    Working Capital Assets/Liability
                </h6>
                <div class="block-handle"></div>
            </div>
            <div>
                <table class="summary-table text-capitalize">
                    <thead>
                        @foreach($commercialExpenseFieldPaymentDueValues as $key=>$field)
                            <tr>
                                <th>{{ $key }}</th>
                                <th>{{ $field }}</th>
                            </tr>
                        @endforeach
                        <tr>
                            <th>BTB </th>
                            <th>{{ $allCommercialPaymentDue - array_sum($commercialExpenseFieldPaymentDueValues) }}</th>
                        </tr>
                        <tr>
                            <th class="bg-secondary text-white"> ------- </th>
                            <th class="bg-secondary text-white">{{ $allCommercialPaymentDue }}</th>
                        </tr>

                        <tr>
                            <th>Receivable from cash LC</th>
                            <th>{{ $businessGap->receivable_from_cash_lc ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>USD Ac Balance</th>
                            <th>{{ $businessGap->usd_ac_balance ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>Cash incentive</th>
                            <th>{{ $businessGap->cash_incentive ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>FDR</th>
                            <th>{{ $businessGap->fdr ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>USD Ac</th>
                            <th>{{ $businessGap->usd_ac ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>AC receivable</th>
                            <th>{{ $businessGap->ac_receivable ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>Yarn Block lC</th>
                            <th>{{ $businessGap->yarn_block_lc ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>Others</th>
                            <th>{{ $businessGap->others ?? 0 }}</th>
                        </tr>
                        <tr>
                            <th>Stock/inventory</th>
                            <th>{{ $businessGap->stock_or_inventory ?? 0 }}</th>
                        </tr>

                        <tr>
                            <th class="bg-secondary text-white"> ------- </th>
                            <th class="bg-secondary text-white">{{ $businessGapSum }}</th>
                        </tr>

                        <tr>
                            <th class="font-weight-bolder">Difference Gap</th>
                            <th class="font-weight-bolder">{{ $allCommercialPaymentDue - $businessGapSum }}</th>
                        </tr>

                    </thead>
                </table>
            </div>
        </div>
        </div>

            <!-- End Default Light Table -->
    </div>
@endsection

@section('vue-script')

@endsection

