<table class="main-data-table d-none text-capitalize" id="main-table">
    <thead>
    <tr>
        <th>SL</th>
        <th>ID</th>
        <th style="background: #a2f358;color: #000;">Invoice Number</th>
        <th style="background: #a2f358;color: #000;">Invoice Date</th>
        <th style="background: #a2f358;color: #000;">Invoice Value</th>
        <th>Buyer</th>
        <th style="background: #ffd3b0;color: #000;">Payment Mode</th>
        <th style="background: #93a8ff;color: #000;">Master L/C No or S/C No</th>
        <th style="background: #93a8ff;color: #000;">Ex. Factory Date</th>
        <th>B/L Date</th>
        <th style="background: #f68a8a;color: #000;">Payment Receive Date</th>
        <th style="background: #f68a8a;color: #000;">Payment Receive Amount</th>
        <th style="background: #f68a8a;color: #000;">Payment Receive Status</th>
        <th>Document Purchase Date</th>
        <th>Document Purchase Amount</th>
{{--        automated --}}
        <th>Short or Access Payment</th>
        <th>Payment Overdue Days</th>

        <th>Action</th>
    </tr>
    </thead>
    <tbody>
    {{--
        SL
        ID
        invoice_number
        invoice_date
        invoice_value
        buyer_id
        payment_mode
        master_lc_no_OR_sc_no
        ex_factory_date
        bl_date
        payment_receive_date
        payment_receive_amount
        payment_receive_status
        document_purchase_date
        document_purchase_amount

        short_or_access_payment
        payment_overdue_days
    --}}
    @foreach($commercial_invoices as $invoice)

        <?php

        $payment_overdue_days = Carbon::parse($invoice->bl_date)->addDays($invoice->payment_mode)->format('Y-m-d');

        ?>

        <tr>
            {{--SL--}}                  <td>1</td>
            {{--ID--}}             <td class="bg-dark text-white"> {{ $invoice->id }}</td>
            {{--invoice_number--}}   <td>{{  $invoice->invoice_number }}</td>
            {{--invoice_date--}}              <td>{{ $invoice->invoice_date}}</td>
            {{--invoice_value--}}              <td>{{ $invoice->invoice_value}}</td>
            {{--buyer_id--}}              <td>{{ $invoice->buyer->name}}</td>
            {{--payment_mode--}}              <td>{{ $invoice->payment_mode}}</td>
            {{--master_lc_no_OR_sc_no--}}              <td>{{ $invoice->master_lc_no_OR_sc_no}}</td>
            {{--ex_factory_date--}}              <td>{{ $invoice->ex_factory_date}}</td>
            {{--bl_date--}}              <td>{{ $invoice->bl_date}}</td>
            {{--payment_receive_date--}}       <td>{{ $invoice->payment_receive_date}}</td>
            {{--payment_receive_amount--}}       <td>{{ $invoice->payment_receive_amount}}</td>
            {{--payment_receive_status--}}       <td>{{ $invoice->payment_receive_status}}</td>
            {{--document_purchase_date--}}       <td>{{ $invoice->document_purchase_date}}</td>
            {{--document_purchase_amount--}}       <td>{{ $invoice->document_purchase_amount}}</td>

            {{--short_or_access_payment--}}       <td class="font-weight-bold text-info">{{ $invoice->invoice_value - $invoice->payment_receive_amount }}</td>
            {{--payment_overdue_days--}}       <td class="text-white {{ $payment_overdue_days <= date('Y-m-d') ? 'bg-danger':'bg-success' }}">{{ $payment_overdue_days }}</td>


            <td>
                <div class="btn-group btn-group-sm action-area" role="group" aria-label="Table row actions">
                    <a class="btn btn-white" href="{{ route('commercial-invoice-edit', $invoice->id) }}">
                        <i class="material-icons"></i>
                    </a>
                </div>
            </td>
        </tr>
    @endforeach
    <tr>
        <th>SL</th>
        <th>ID</th>
        <th style="background: #a2f358;color: #000;">Invoice Number</th>
        <th style="background: #a2f358;color: #000;">Invoice Date</th>
        <th style="background: #a2f358;color: #000;">Invoice Value</th>
        <th>Buyer</th>
        <th style="background: #ffd3b0;color: #000;">Payment Mode</th>
        <th style="background: #93a8ff;color: #000;">Master L/C No or S/C No</th>
        <th style="background: #93a8ff;color: #000;">Ex. Factory Date</th>
        <th>B/L Date</th>
        <th style="background: #f68a8a;color: #000;">Payment Receive Date</th>
        <th style="background: #f68a8a;color: #000;">Payment Receive Amount</th>
        <th style="background: #f68a8a;color: #000;">Payment Receive Status</th>
        <th>Document Purchase Date</th>
        <th>Document Purchase Amount</th>

        <th>Short or Access Payment</th>
        <th>Payment Overdue Days</th>

        <th>Action</th>
    </tr>
    </tbody>
    <tfoot>
    <tr>
        <th>SL</th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>

        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
    </tr>
    </tfoot>
</table>


